/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.core.registries;

import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.forge.PlatformHelper;
import com.stereowalker.unionlib.mod.MinecraftMod;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterObjects {
    public static final Logger LOGGER = LogManager.getLogger((String)"UnionLib Registry");

    public static void putObjectsInGameRegistries(MinecraftMod mod) {
        final ArrayList regs = new ArrayList();
        mod.setupRegistries(new RegistryCollector(){

            @Override
            public void addRegistryHolder(Class<?> holder) {
                regs.add(holder);
            }
        });
        for (Class classs : regs) {
            if (!classs.isAnnotationPresent(RegistryHolder.class)) {
                LOGGER.info(classs + " is missing the @RegistryHolder annotation. Include it to register the objects in this class");
                continue;
            }
            RegistryHolder reg = classs.getAnnotation(RegistryHolder.class);
            LOGGER.info("Registering " + reg.registry().getSimpleName() + "s in " + classs);
            String namespace = reg.namespace().isEmpty() ? mod.getModid() : reg.namespace();
            PlatformHelper.handleRegistration(mod, namespace, classs.getFields(), reg, LOGGER);
        }
    }
}

