/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mod;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.DefaultAttributeModifier;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.keymaps.KeyMappingCollector;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.forge.ForgeMod;
import com.stereowalker.unionlib.mod.ModHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class MinecraftMod
implements ForgeMod {
    private String modid;
    private LoadType loadType;
    private ResourceLocation modTexture;
    final String NETWORK_PROTOCOL_VERSION = "1";
    public SimpleChannel channel = null;
    public boolean hasInitializedClient = false;
    public boolean hasInitializedServer = false;

    public MinecraftMod(String modid, ResourceLocation modTexture, LoadType loadType, boolean shouldLoadMod) {
        this.modid = modid;
        this.modTexture = modTexture;
        this.loadType = loadType;
        if (shouldLoadMod && !ModHandler.isModRegistered(modid)) {
            ModHandler.registerMod(this);
            this.onModStartup();
            UnionLib.debug("Starting up: " + this.modid, true);
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(this::getConfigScreen));
        }
    }

    public void onModStartup() {
    }

    public void onModStartupInClient() {
    }

    public void modifyDefaultEntityAttributes(DefaultAttributeModifier modifier) {
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
    }

    public void registerCreativeTabs(CreativeTabBuilder builder) {
    }

    public void registerClientRelaodableResources(ReloadListeners reloadListener) {
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
    }

    public void registerInserts(InsertCollector collector) {
    }

    public void setupKeymappings(KeyMappingCollector collector) {
    }

    public void setupRegistries(RegistryCollector collector) {
    }

    public final void setupServerBeforeMinecraft(MinecraftServer mc) {
        if (!this.hasInitializedServer) {
            UnionLib.debug("Initializing mod on server: " + this.modid, true);
            this.initServerBeforeMinecraft(mc);
            this.hasInitializedServer = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void setupClientAfterMinecraft(Minecraft mc) {
        if (!this.hasInitializedClient) {
            UnionLib.debug("Initializing mod on client: " + this.modid, true);
            this.initClientAfterMinecraft(mc);
            this.hasInitializedClient = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClientAfterMinecraft(Minecraft mc) {
    }

    public void initServerBeforeMinecraft(MinecraftServer mc) {
    }

    public MinecraftMod(String modid, ResourceLocation modTexture, LoadType loadType) {
        this(modid, modTexture, loadType, true);
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    @Override
    public String getModid() {
        return this.modid;
    }

    public Logger getLogger() {
        return LogManager.getLogger((String)this.modid);
    }

    public ResourceLocation getModTexture() {
        return this.modTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
        return null;
    }

    public ResourceLocation location(String name) {
        return new ResourceLocation(this.modid, name);
    }

    public String locationString(String name) {
        return this.modid + ":" + name;
    }

    public String getVersion() {
        if (this.getModInfo() != null) {
            return MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)this.getModInfo().getVersion());
        }
        return "???";
    }

    public static enum LoadType {
        CLIENT,
        BOTH,
        SERVER;


        public boolean onClient() {
            return this == CLIENT || this == BOTH;
        }

        public boolean onServer() {
            return this == SERVER || this == BOTH;
        }
    }
}

