/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mod;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.core.registries.UnionLibRegistry;
import com.stereowalker.unionlib.insert.InsertSystem;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.network.PacketRegistry;
import com.stereowalker.unionlib.network.protocol.game.BasePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.mutable.MutableInt;

public class ModHandler {
    private static LoadState loadState = null;
    public static final Map<String, MinecraftMod> mods = new HashMap<String, MinecraftMod>();
    private static final List<MinecraftMod> clientInitializableMods = new ArrayList<MinecraftMod>();
    private static final List<MinecraftMod> serverInitializableMods = new ArrayList<MinecraftMod>();
    private static boolean hasHandledServerPackets = false;
    private static boolean hasHandledClientPackets = false;
    private static MinecraftMod unionLib = null;

    public static boolean isModRegistered(String mod) {
        return mods.containsKey(mod);
    }

    public static LoadState getLoadState() {
        return loadState;
    }

    public static void registerPacketsOnDedicatedServer() {
        if (!hasHandledServerPackets) {
            for (final MinecraftMod mod : mods.values()) {
                if (!(mod instanceof PacketHolder)) continue;
                UnionLib.debug("Registering packets on server for mod: " + mod.getModid());
                if (mod.getLoadType() == MinecraftMod.LoadType.BOTH && ModHandler.getLoadState() == LoadState.BOTH) {
                    if (mod.channel == null) {
                        mod.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)(((PacketHolder)((Object)mod)).channelName() == null ? mod.location("main_simple_channel") : ((PacketHolder)((Object)mod)).channelName()), () -> mod.NETWORK_PROTOCOL_VERSION, mod.NETWORK_PROTOCOL_VERSION::equals, mod.NETWORK_PROTOCOL_VERSION::equals);
                    }
                    final MutableInt id = new MutableInt();
                    ((PacketHolder)((Object)mod)).registerClientboundPackets(new PacketCollector(){

                        @Override
                        public <T extends BasePacket> void registerPacket(Class<T> messageType, Function<FriendlyByteBuf, T> decoder) {
                            PacketRegistry.registerMessage(mod.channel, id.intValue(), messageType, decoder);
                            id.increment();
                        }
                    });
                    ((PacketHolder)((Object)mod)).registerServerboundPackets(new PacketCollector(){

                        @Override
                        public <T extends BasePacket> void registerPacket(Class<T> messageType, Function<FriendlyByteBuf, T> decoder) {
                            PacketRegistry.registerMessage(mod.channel, id.intValue(), messageType, decoder);
                            id.increment();
                        }
                    });
                    UnionLib.debug(mod.getModid() + "'s Serverbound & Clientbound packets registered");
                    continue;
                }
                UnionLib.debug("Not registering " + mod.getModid() + "'s Serverbound packets Because [This: -> " + mod.getLoadType() + " <- Game: -> " + ModHandler.getLoadState() + " <-]");
            }
            hasHandledServerPackets = true;
        }
    }

    public static void registerAllClientRelaodableResources(ReloadableResourceManager resourceManager) {
        ReloadListeners reloaders = arg_0 -> ((ReloadableResourceManager)resourceManager).m_7217_(arg_0);
        mods.values().forEach(mod -> mod.registerClientRelaodableResources(reloaders));
    }

    public static void registerAllServerRelaodableResources(AddReloadListenerEvent resourceManager) {
        ReloadListeners reloaders = arg_0 -> ((AddReloadListenerEvent)resourceManager).addListener(arg_0);
        mods.values().forEach(mod -> mod.registerServerRelaodableResources(reloaders));
    }

    public static void registerPacketsOnClient() {
        if (!hasHandledClientPackets) {
            for (final MinecraftMod mod : mods.values()) {
                if (!(mod instanceof PacketHolder)) continue;
                UnionLib.debug("Registering packets on client for mod: " + mod.getModid());
                if (mod.getLoadType() == MinecraftMod.LoadType.BOTH && ModHandler.getLoadState() == LoadState.BOTH) {
                    if (mod.channel == null) {
                        mod.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)(((PacketHolder)((Object)mod)).channelName() == null ? mod.location("main_simple_channel") : ((PacketHolder)((Object)mod)).channelName()), () -> mod.NETWORK_PROTOCOL_VERSION, mod.NETWORK_PROTOCOL_VERSION::equals, mod.NETWORK_PROTOCOL_VERSION::equals);
                    }
                    final MutableInt id = new MutableInt();
                    ((PacketHolder)((Object)mod)).registerClientboundPackets(new PacketCollector(){

                        @Override
                        public <T extends BasePacket> void registerPacket(Class<T> messageType, Function<FriendlyByteBuf, T> decoder) {
                            PacketRegistry.registerMessage(mod.channel, id.intValue(), messageType, decoder);
                            id.increment();
                        }
                    });
                    ((PacketHolder)((Object)mod)).registerServerboundPackets(new PacketCollector(){

                        @Override
                        public <T extends BasePacket> void registerPacket(Class<T> messageType, Function<FriendlyByteBuf, T> decoder) {
                            PacketRegistry.registerMessage(mod.channel, id.intValue(), messageType, decoder);
                            id.increment();
                        }
                    });
                    UnionLib.debug(mod.getModid() + "'s Clientbound packets registered", true);
                    continue;
                }
                UnionLib.debug("Not registering " + mod.getModid() + "'s Clientbound packets Because This: -> " + mod.getLoadType() + " Game: -> " + ModHandler.getLoadState(), true);
            }
            hasHandledClientPackets = true;
        }
    }

    public static void doServerInitialization(MinecraftServer mc) {
        if (serverInitializableMods.size() > 0) {
            UnionLib.debug("Attempting to initialize mod on server. There are " + serverInitializableMods.size() + " mods that will require this process");
            ArrayList<MinecraftMod> initializaed = new ArrayList<MinecraftMod>();
            for (MinecraftMod mod : serverInitializableMods) {
                mod.setupServerBeforeMinecraft(mc);
                if (!mod.hasInitializedServer) continue;
                initializaed.add(mod);
            }
            serverInitializableMods.removeAll(initializaed);
            UnionLib.debug("Successfully initialized " + initializaed.size() + " mods on the server");
        }
    }

    public static void doClientInitialization(Minecraft mc) {
        if (clientInitializableMods.size() > 0) {
            UnionLib.debug("Attempting to initialize mod on client. There are " + clientInitializableMods.size() + " mods that will require this process");
            ArrayList<MinecraftMod> initializaed = new ArrayList<MinecraftMod>();
            MinecraftMod unionlib = null;
            for (MinecraftMod mod : clientInitializableMods) {
                if (!mod.getModid().equals("unionlib")) continue;
                unionlib = mod;
                break;
            }
            clientInitializableMods.remove(unionlib);
            clientInitializableMods.add(unionlib);
            for (MinecraftMod mod : clientInitializableMods) {
                mod.setupClientAfterMinecraft(mc);
                if (!mod.hasInitializedClient) continue;
                initializaed.add(mod);
            }
            clientInitializableMods.removeAll(initializaed);
            UnionLib.debug("Successfully initialized " + initializaed.size() + " mods on the client");
        }
    }

    public static void registerMod(MinecraftMod mod) {
        mods.put(mod.getModid(), mod);
        mod.registerInserts(InsertSystem.instance);
        if (mod.getLoadType().onClient() && FMLEnvironment.dist == Dist.CLIENT) {
            clientInitializableMods.add(mod);
        }
        if (mod.getLoadType().onServer()) {
            serverInitializableMods.add(mod);
        }
        if (loadState != LoadState.BOTH) {
            if (mod.getModid().equals("unionlib") && mods.size() == 1) {
                UnionLib.debug("Only UnionLib for now");
                loadState = LoadState.ONLY_UNIONLIB;
            } else if (mod.getModid().equals("unionlib") && mods.size() > 1) {
                UnionLib.debug("UnionLib cannot affect the load type");
            } else {
                if (loadState == LoadState.ONLY_UNIONLIB) {
                    UnionLib.debug("UnionLib is no longer the only mod, we found " + mod.getModid());
                    loadState = null;
                }
                if (mod.getLoadType() == MinecraftMod.LoadType.BOTH) {
                    loadState = LoadState.BOTH;
                } else if (mod.getLoadType() == MinecraftMod.LoadType.CLIENT) {
                    loadState = loadState == LoadState.SERVER ? LoadState.BOTH : LoadState.CLIENT;
                } else if (mod.getLoadType() == MinecraftMod.LoadType.SERVER) {
                    loadState = loadState == LoadState.CLIENT ? LoadState.BOTH : LoadState.SERVER;
                }
            }
        }
        if (mod.getModid().equals("unionlib")) {
            unionLib = mod;
        } else {
            if (mod.getLoadType() == MinecraftMod.LoadType.BOTH && unionLib != null) {
                UnionLibRegistry.registerObjects(unionLib);
                unionLib = null;
            }
            UnionLibRegistry.registerObjects(mod);
        }
    }

    public static enum LoadState {
        CLIENT,
        BOTH,
        SERVER,
        ONLY_UNIONLIB;


        public boolean runsOnClient() {
            return this == CLIENT || this == BOTH || this == ONLY_UNIONLIB;
        }

        public boolean runsOnServer() {
            return this == SERVER || this == BOTH;
        }

        public boolean runsOnlyOnClient() {
            return this == CLIENT || this == ONLY_UNIONLIB;
        }

        public boolean runsOnlyOnServer() {
            return this == SERVER;
        }

        public boolean runsOnBothSides() {
            return this == BOTH;
        }
    }
}

