/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered;

import com.google.common.collect.Multimap;
import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.api.CustomEntityAttributes;
import draylar.tiered.api.ModifierUtils;
import draylar.tiered.api.PotentialAttribute;
import draylar.tiered.api.TieredItemTags;
import draylar.tiered.config.ConfigInit;
import draylar.tiered.data.AttributeDataLoader;
import draylar.tiered.network.TieredServerPacket;
import draylar.tiered.reforge.ReforgeScreenHandler;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1661;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Tiered
implements ModInitializer {
    public static final boolean isLevelZLoaded = FabricLoader.getInstance().isModLoaded("levelz");
    public static final AttributeDataLoader ATTRIBUTE_DATA_LOADER = new AttributeDataLoader();
    public static class_3917<ReforgeScreenHandler> REFORGE_SCREEN_HANDLER_TYPE;
    public static final UUID[] MODIFIERS;
    public static final Logger LOGGER;
    public static final class_2960 ATTRIBUTE_SYNC_PACKET;
    public static final String NBT_SUBTAG_KEY = "Tiered";
    public static final String NBT_SUBTAG_DATA_KEY = "Tier";

    public void onInitialize() {
        ConfigInit.init();
        TieredItemTags.init();
        CustomEntityAttributes.init();
        Tiered.registerAttributeSyncer();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)ATTRIBUTE_DATA_LOADER);
        REFORGE_SCREEN_HANDLER_TYPE = (class_3917)class_2378.method_10226((class_2378)class_2378.field_17429, (String)"tiered", (Object)new class_3917((syncId, inventory) -> new ReforgeScreenHandler(syncId, inventory, class_3914.field_17304)));
        TieredServerPacket.init();
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> {
            if (success) {
                for (int i = 0; i < server.method_3760().method_14571().size(); ++i) {
                    Tiered.updateItemStackNbt(((class_3222)server.method_3760().method_14571().get(i)).method_31548());
                }
                LOGGER.info("Finished reload on {}", (Object)Thread.currentThread());
            } else {
                LOGGER.error("Failed to reload on {}", (Object)Thread.currentThread());
            }
        });
        ServerPlayConnectionEvents.INIT.register((handler, server) -> Tiered.updateItemStackNbt(handler.field_14140.method_31548()));
        ModifyItemAttributeModifiersCallback.EVENT.register((itemStack, slot, modifiers) -> {
            if (itemStack.method_7941(NBT_SUBTAG_KEY) != null) {
                PotentialAttribute potentialAttribute;
                class_2960 tier = new class_2960(itemStack.method_7911(NBT_SUBTAG_KEY).method_10558(NBT_SUBTAG_DATA_KEY));
                if (!(itemStack.method_7985() && itemStack.method_7969().method_10573("AttributeModifiers", 9) || (potentialAttribute = ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier)) == null)) {
                    potentialAttribute.getAttributes().forEach(template -> {
                        ArrayList<class_1304> optionalEquipmentSlots;
                        ArrayList<class_1304> requiredEquipmentSlots;
                        if (template.getRequiredEquipmentSlots() != null && (requiredEquipmentSlots = new ArrayList<class_1304>(Arrays.asList(template.getRequiredEquipmentSlots()))).contains(slot)) {
                            template.realize((Multimap<class_1320, class_1322>)modifiers, slot);
                        }
                        if (template.getOptionalEquipmentSlots() != null && (optionalEquipmentSlots = new ArrayList<class_1304>(Arrays.asList(template.getOptionalEquipmentSlots()))).contains(slot) && Tiered.isPreferredEquipmentSlot(itemStack, slot)) {
                            template.realize((Multimap<class_1320, class_1322>)modifiers, slot);
                        }
                    });
                }
            }
        });
    }

    public static class_2960 id(String path) {
        return new class_2960("tiered", path);
    }

    private void setupModifierLabel() {
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, lines) -> {
            if (stack.method_7941(NBT_SUBTAG_KEY) != null) {
                class_2960 tier = new class_2960(stack.method_7911(NBT_SUBTAG_KEY).method_10558(NBT_SUBTAG_DATA_KEY));
                PotentialAttribute potentialAttribute = ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier);
                if (potentialAttribute != null) {
                    lines.add(1, class_2561.method_43471((String)(potentialAttribute.getID() + ".label")).method_10862(potentialAttribute.getStyle()));
                }
            }
        });
    }

    public static boolean isPreferredEquipmentSlot(class_1799 stack, class_1304 slot) {
        if (stack.method_7909() instanceof class_1738) {
            class_1738 item = (class_1738)stack.method_7909();
            return item.method_7685().equals((Object)slot);
        }
        if (stack.method_7909() instanceof class_1819) {
            return slot == class_1304.field_6173 || slot == class_1304.field_6171;
        }
        return slot == class_1304.field_6173;
    }

    public static void registerAttributeSyncer() {
        ServerPlayConnectionEvents.JOIN.register((network, packetSender, minecraftServer) -> {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.writeInt(ATTRIBUTE_DATA_LOADER.getItemAttributes().size());
            ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
                packet.method_10814(id.toString());
                packet.method_10814(AttributeDataLoader.GSON.toJson(attribute));
            });
            packetSender.sendPacket(ATTRIBUTE_SYNC_PACKET, packet);
        });
    }

    public static void updateItemStackNbt(class_1661 playerInventory) {
        for (int u = 0; u < playerInventory.method_5439(); ++u) {
            class_1799 itemStack = playerInventory.method_5438(u);
            if (itemStack.method_7960() || itemStack.method_7941(NBT_SUBTAG_KEY) == null) continue;
            ArrayList attributeIds = new ArrayList();
            ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
                if (attribute.isValid(class_2378.field_11142.method_10221((Object)itemStack.method_7909()))) {
                    attributeIds.add(attribute.getID());
                }
            });
            class_2960 attributeID = null;
            for (int i = 0; i < attributeIds.size(); ++i) {
                if (itemStack.method_7941(NBT_SUBTAG_KEY).method_10714().contains((CharSequence)attributeIds.get(i))) {
                    attributeID = new class_2960((String)attributeIds.get(i));
                    break;
                }
                if (i != attributeIds.size() - 1) continue;
                ModifierUtils.removeItemStackAttribute(itemStack);
                attributeID = ModifierUtils.getRandomAttributeIDFor(null, itemStack.method_7909(), false);
            }
            if (attributeID == null) continue;
            HashMap<String, Object> nbtMap = ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(attributeID.toString())).getNbtValues();
            List<AttributeTemplate> attributeList = ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(attributeID.toString())).getAttributes();
            for (int i = 0; i < attributeList.size(); ++i) {
                if (!attributeList.get(i).getAttributeTypeID().equals("tiered:generic.durable")) continue;
                if (nbtMap == null) {
                    nbtMap = new HashMap();
                }
                nbtMap.put("durable", (double)Math.round(attributeList.get(i).getEntityAttributeModifier().method_6186() * 100.0) / 100.0);
                break;
            }
            if (nbtMap != null) {
                class_2487 nbtCompound = itemStack.method_7969();
                for (Map.Entry<String, Object> entry : nbtMap.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        nbtCompound.method_10582(key, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        nbtCompound.method_10556(key, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    if ((Double)value % 1.0 < 1.0E-4) {
                        nbtCompound.method_10569(key, (int)Math.round((Double)value));
                        continue;
                    }
                    nbtCompound.method_10549(key, (double)Math.round((Double)value * 100.0) / 100.0);
                }
                itemStack.method_7980(nbtCompound);
            }
            if (itemStack.method_7941(NBT_SUBTAG_KEY) == null) {
                itemStack.method_7911(NBT_SUBTAG_KEY).method_10582(NBT_SUBTAG_DATA_KEY, attributeID.toString());
            }
            playerInventory.method_5447(u, itemStack);
        }
    }

    static {
        MODIFIERS = new UUID[]{UUID.fromString("baf8e074-f7f9-4549-ba1f-e21f82684b8c"), UUID.fromString("9b3416de-98d1-407f-bc6b-e673c2ab5252"), UUID.fromString("1e3ceca6-aa30-4165-9715-20bb63c11348"), UUID.fromString("c99bfa17-4886-4cbb-86c2-ebf9369616d5"), UUID.fromString("19e4dc8d-3892-4ffe-a558-f96c68491144"), UUID.fromString("b1641cff-84ed-4b63-85f8-2634005adc9b"), UUID.fromString("92f546e9-0d00-4159-8c8f-0499e49f5811"), UUID.fromString("e25c7fa8-13b0-4ea0-8db7-e26b78f36c90"), UUID.fromString("2f9dcfce-bd03-4181-86b7-91c88f71e67c")};
        LOGGER = LogManager.getLogger();
        ATTRIBUTE_SYNC_PACKET = new class_2960("attribute_sync");
    }
}

