/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import draylar.tiered.api.ItemVerifier;
import draylar.tiered.api.ReforgeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReforgeItemDataLoader
extends class_4309
implements SimpleSynchronousResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading reforge item data {}";
    private static final String LOADED_MESSAGE = "Loaded {} reforge item data";
    private final List<ReforgeItem> reforgeItems = new ArrayList<ReforgeItem>();

    public ReforgeItemDataLoader() {
        super(GSON, "reforge_item");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap<ItemVerifier, ReforgeItem> readReforgeItems = new HashMap<ItemVerifier, ReforgeItem>();
        for (Map.Entry<class_2960, JsonElement> entry : loader.entrySet()) {
            class_2960 identifier = entry.getKey();
            try {
                ReforgeItem reforgeItem = (ReforgeItem)GSON.fromJson(entry.getValue(), ReforgeItem.class);
                if (reforgeItem.getProduct() == null) continue;
                readReforgeItems.put(reforgeItem.getProduct(), reforgeItem);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.reforgeItems.clear();
        this.reforgeItems.addAll(readReforgeItems.values().stream().sorted(Comparator.comparing(ReforgeItem::isCover).thenComparing(a -> a.getProduct().getId() == null ? "" : a.getProduct().getId()).reversed()).toList());
        LOGGER.info(LOADED_MESSAGE, (Object)this.reforgeItems.size());
    }

    public List<ReforgeItem> getReforgeItems() {
        return this.reforgeItems;
    }

    public List<class_1799> getReforgeItems(class_1792 product) {
        List<ReforgeItem> filtered = this.reforgeItems.stream().filter(it -> it.getProduct().isValid(class_2378.field_11142.method_10221((Object)product))).toList();
        if (filtered.stream().anyMatch(ReforgeItem::isCover)) {
            filtered = filtered.stream().filter(ReforgeItem::isCover).findFirst().stream().toList();
        }
        if (filtered.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet itemVerifiers = new HashSet();
        filtered.forEach(value -> itemVerifiers.addAll(value.getBase()));
        HashSet bases = new HashSet();
        for (ItemVerifier verifier : itemVerifiers) {
            if (verifier.getId() != null) {
                Optional item = class_2378.field_11142.method_17966(class_2960.method_12829((String)verifier.getId()));
                item.ifPresent(value -> bases.add(value.method_7854()));
                continue;
            }
            if (verifier.getTagKey() == null) continue;
            Optional entryList = class_2378.field_11142.method_40266(verifier.getTagKey());
            entryList.ifPresent(value -> bases.addAll(value.method_40239().map(it -> ((class_1792)it.comp_349()).method_7854()).toList()));
        }
        return bases.stream().sorted(Comparator.comparing(c -> c.method_7964().getString())).collect(Collectors.toList());
    }

    public class_2960 getFabricId() {
        return new class_2960("tiered", "reforge_item");
    }

    public void method_14491(class_3300 resourceManager) {
    }
}

