/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tntslimes.datagen;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrbysco.tntslimes.registry.SlimeRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SlimeDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        HolderLookup.Provider provider = SlimeDatagen.getProvider();
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new ItemModels(packOutput, helper));
            HolderLookup.RegistryLookup biomeReg = provider.m_255025_(Registries.f_256952_);
            ForgeBiomeModifiers.AddSpawnsBiomeModifier addSpawn = ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)HolderSet.m_255229_((HolderOwner)biomeReg, (TagKey)BiomeTags.f_215817_), (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)SlimeRegistry.TNT_SLIME.get(), 1, 2, 10));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(SlimeDatagen::getProvider), Set.of("tntslimes")));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeHolderGetter = context.m_255420_(Registries.f_256952_);
            ForgeBiomeModifiers.AddSpawnsBiomeModifier addSpawn = ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)biomeHolderGetter.m_254956_(BiomeTags.f_215817_), (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)SlimeRegistry.TNT_SLIME.get(), 1, 2, 10));
            context.m_255272_(SlimeDatagen.createModifierKey("add_tnt_slime_spawn"), (Object)addSpawn);
        });
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }

    private static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("tntslimes", name));
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(SlimeLootTables::new, LootContextParamSets.f_81415_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class SlimeLootTables
        extends EntityLootSubProvider {
            protected SlimeLootTables() {
                super(FeatureFlags.f_244280_.m_247355_());
            }

            public void m_246942_() {
                this.m_245309_((EntityType)SlimeRegistry.TNT_SLIME.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50077_)).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f))));
            }

            protected Stream<EntityType<?>> getKnownEntityTypes() {
                return SlimeRegistry.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get);
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "tntslimes", "en_us");
        }

        protected void addTranslations() {
            this.addEntityType((Supplier)SlimeRegistry.TNT_SLIME, "TNT Slime");
            this.addItem((Supplier)SlimeRegistry.TNT_SLIME_SPAWN_EGG, "TNT Slime Spawn Egg");
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "tntslimes", helper);
        }

        protected void registerModels() {
            for (RegistryObject item : SlimeRegistry.ITEMS.getEntries()) {
                if (!(item.get() instanceof SpawnEggItem)) continue;
                this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)((Item)item.get())).m_135815_(), new ResourceLocation("item/template_spawn_egg"));
            }
        }
    }
}

