/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.tntslimes.entity;

import com.mrbysco.tntslimes.config.SlimeConfig;
import com.mrbysco.tntslimes.entity.goal.TNTSlimeSwellGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraftforge.event.ForgeEventFactory;

public class TNTSlime
extends Slime {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(TNTSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(TNTSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 2;

    public TNTSlime(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new TNTSlimeSwellGoal(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128376_("Fuse", (short)this.maxSwell);
        tag.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        tag.m_128379_("ignited", this.isIgnited());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Fuse", 99)) {
            this.maxSwell = tag.m_128448_("Fuse");
        }
        if (tag.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = tag.m_128445_("ExplosionRadius");
        }
        if (tag.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public float getSwelling(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int dir) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)dir);
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeSlime();
            }
        }
        super.m_8119_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (itemstack.m_150930_(Items.f_42409_)) {
            this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)player, p_32290_ -> p_32290_.m_21190_(interactionHand));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    private void explodeSlime() {
        if (!this.f_19853_.f_46443_) {
            Level.ExplosionInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            float f = 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, explosion$blockinteraction);
            this.m_146870_();
        }
    }

    protected boolean m_7483_() {
        return false;
    }

    public void m_7839_(int size, boolean resetHealth) {
        int i = Mth.m_14045_((int)size, (int)1, (int)127);
        this.explosionRadius = Mth.m_14045_((int)size, (int)1, (int)16);
        this.f_19804_.m_135381_(f_33582_, (Object)i);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)size);
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.2f + 0.1f * (float)i));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)i);
        if (resetHealth) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = i;
    }

    public static boolean checkTNTSlimeSpawnRules(EntityType<TNTSlime> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (level.m_46791_() != Difficulty.PEACEFUL) {
            boolean flag;
            if (level.m_204166_(pos).m_203565_(Biomes.f_48207_) && pos.m_123342_() > 50 && pos.m_123342_() < 70 && random.m_188501_() < 0.5f && random.m_188501_() < level.m_46940_() && level.m_46803_(pos) <= random.m_188503_(8)) {
                return TNTSlime.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
            }
            if (!(level instanceof WorldGenLevel)) {
                return false;
            }
            ChunkPos chunkpos = new ChunkPos(pos);
            boolean bl = flag = WorldgenRandom.m_224681_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (long)((WorldGenLevel)level).m_7328_(), (long)987234911L).m_188503_(10) == 0;
            if (random.m_188503_(10) == 0 && flag && pos.m_123342_() < (Integer)SlimeConfig.COMMON.minY.get()) {
                return TNTSlime.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
            }
        }
        return false;
    }
}

