/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.uniquedaysandnights.network;

import java.util.function.Supplier;
import net.mcreator.uniquedaysandnights.UniqueDaysAndNightsMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UniqueDaysAndNightsModVariables {
    public static double creeperLimit = 0.0;
    public static double zombieLimit = 0.0;
    public static double timer = 0.0;
    public static double bitingChance = 0.01;
    public static double fluffMultiplier = 0.0;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        UniqueDaysAndNightsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "unique_days_and_nights_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                UniqueDaysAndNightsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "unique_days_and_nights_worldvars";
        public boolean nightstart = false;
        public boolean daystart = false;
        public boolean normalday = false;
        public boolean normalnight = false;
        public boolean d = true;
        public boolean n = false;
        public boolean info = true;
        public boolean zombienight = false;
        public boolean pause = false;
        public boolean thunderreset = false;
        public boolean luckyday = false;
        public boolean minersday = false;
        public boolean creepernight = false;
        public boolean hotday = false;
        public boolean rainday = false;
        public boolean fluffingday = false;
        public boolean rainreset = false;
        public boolean thundernight = false;
        public boolean bitingday = false;
        public boolean moonnight = false;
        public boolean ghostnight = false;
        public boolean darknight = false;
        public boolean hungryday = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.nightstart = nbt.m_128471_("nightstart");
            this.daystart = nbt.m_128471_("daystart");
            this.normalday = nbt.m_128471_("normalday");
            this.normalnight = nbt.m_128471_("normalnight");
            this.d = nbt.m_128471_("d");
            this.n = nbt.m_128471_("n");
            this.info = nbt.m_128471_("info");
            this.zombienight = nbt.m_128471_("zombienight");
            this.pause = nbt.m_128471_("pause");
            this.thunderreset = nbt.m_128471_("thunderreset");
            this.luckyday = nbt.m_128471_("luckyday");
            this.minersday = nbt.m_128471_("minersday");
            this.creepernight = nbt.m_128471_("creepernight");
            this.hotday = nbt.m_128471_("hotday");
            this.rainday = nbt.m_128471_("rainday");
            this.fluffingday = nbt.m_128471_("fluffingday");
            this.rainreset = nbt.m_128471_("rainreset");
            this.thundernight = nbt.m_128471_("thundernight");
            this.bitingday = nbt.m_128471_("bitingday");
            this.moonnight = nbt.m_128471_("moonnight");
            this.ghostnight = nbt.m_128471_("ghostnight");
            this.darknight = nbt.m_128471_("darknight");
            this.hungryday = nbt.m_128471_("hungryday");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("nightstart", this.nightstart);
            nbt.m_128379_("daystart", this.daystart);
            nbt.m_128379_("normalday", this.normalday);
            nbt.m_128379_("normalnight", this.normalnight);
            nbt.m_128379_("d", this.d);
            nbt.m_128379_("n", this.n);
            nbt.m_128379_("info", this.info);
            nbt.m_128379_("zombienight", this.zombienight);
            nbt.m_128379_("pause", this.pause);
            nbt.m_128379_("thunderreset", this.thunderreset);
            nbt.m_128379_("luckyday", this.luckyday);
            nbt.m_128379_("minersday", this.minersday);
            nbt.m_128379_("creepernight", this.creepernight);
            nbt.m_128379_("hotday", this.hotday);
            nbt.m_128379_("rainday", this.rainday);
            nbt.m_128379_("fluffingday", this.fluffingday);
            nbt.m_128379_("rainreset", this.rainreset);
            nbt.m_128379_("thundernight", this.thundernight);
            nbt.m_128379_("bitingday", this.bitingday);
            nbt.m_128379_("moonnight", this.moonnight);
            nbt.m_128379_("ghostnight", this.ghostnight);
            nbt.m_128379_("darknight", this.darknight);
            nbt.m_128379_("hungryday", this.hungryday);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                UniqueDaysAndNightsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    UniqueDaysAndNightsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    UniqueDaysAndNightsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                UniqueDaysAndNightsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

