/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage.config;

import com.tiviacz.warriorrage.config.WarriorRageConfigData;
import com.tiviacz.warriorrage.network.ModNetwork;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class WarriorRageConfig {
    public static int minimalKillCount;
    public static int rageDuration;
    public static int maxKillCountCap;
    public static int killIntervalBetweenNextBonus;
    public static double bonusDamageMultiplier;
    public static boolean enableFireDamage;
    public static boolean renderRageOverlay;
    public static int offsetX;
    public static int offsetY;

    public static void setup() {
        WarriorRageConfigData data = (WarriorRageConfigData)AutoConfig.register(WarriorRageConfigData.class, JanksonConfigSerializer::new).getConfig();
        WarriorRageConfig.bake(null, data);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> WarriorRageConfig.bake(server, data));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, b) -> WarriorRageConfig.bake(server, data));
    }

    public static void bake(MinecraftServer server, WarriorRageConfigData data) {
        minimalKillCount = data.minimalKillCount;
        rageDuration = data.rageDuration;
        maxKillCountCap = data.maxKillCountCap;
        killIntervalBetweenNextBonus = data.killIntervalBetweenNextBonus;
        bonusDamageMultiplier = data.bonusDamageMultiplier;
        enableFireDamage = data.enableFireDamage;
        if (server == null) {
            renderRageOverlay = data.renderRageOverlay;
            offsetX = data.offsetX;
            offsetY = data.offsetY;
        } else {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10794(WarriorRageConfig.toNbt());
            server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)ModNetwork.UPDATE_CONFIG_ID, (class_2540)buf));
        }
    }

    public static class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("minimalKillCount", minimalKillCount);
        nbt.method_10569("rageDuration", rageDuration);
        nbt.method_10569("maxKillCountCap", maxKillCountCap);
        nbt.method_10569("killIntervalBetweenNextBonus", killIntervalBetweenNextBonus);
        nbt.method_10549("bonusDamageMultiplier", bonusDamageMultiplier);
        nbt.method_10556("enableFireDamage", enableFireDamage);
        return nbt;
    }

    public static void fromNbt(class_2487 nbt) {
        minimalKillCount = nbt.method_10550("minimalKillCount");
        rageDuration = nbt.method_10550("rageDuration");
        maxKillCountCap = nbt.method_10550("maxKillCountCap");
        killIntervalBetweenNextBonus = nbt.method_10550("killIntervalBetweenNextBonus");
        bonusDamageMultiplier = nbt.method_10574("bonusDamageMultiplier");
        enableFireDamage = nbt.method_10577("enableFireDamage");
    }
}

