/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage.mixin;

import com.tiviacz.warriorrage.component.ComponentUtils;
import com.tiviacz.warriorrage.component.IRage;
import com.tiviacz.warriorrage.config.WarriorRageConfig;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    private static int tick = 0;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"dropInventory"})
    private void onDeath(CallbackInfo info) {
        PlayerEntityMixin playerEntityMixin;
        if (this instanceof Object && (playerEntityMixin = this) instanceof class_1657) {
            class_1657 player = (class_1657)playerEntityMixin;
            if (ComponentUtils.RAGE.isProvidedBy((Object)player)) {
                ComponentUtils.getComponent(player).removeRageEffects();
                ComponentUtils.getComponent(player).setKillCount(0);
            }
            ComponentUtils.sync(player);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void rageTick(CallbackInfo info) {
        class_1657 player;
        PlayerEntityMixin playerEntityMixin;
        if (this instanceof Object && (playerEntityMixin = this) instanceof class_1657 && ComponentUtils.RAGE.isProvidedBy((Object)(player = (class_1657)playerEntityMixin))) {
            IRage rage = ComponentUtils.getComponent(player);
            if (rage.canStartRage()) {
                PlayerEntityMixin.addParticlesAroundSelf((class_2394)class_2398.field_11240, player);
                rage.startRage();
                rage.decreaseRageDuration();
            } else if (rage.getRemainingRageDuration() > 0 && rage.getCurrentKillCount() < WarriorRageConfig.minimalKillCount) {
                rage.decreaseRageDuration();
            } else {
                rage.removeRageEffects();
            }
        }
    }

    private static void addParticlesAroundSelf(class_2394 particleEffect, class_1657 player) {
        if (++tick == 50) {
            for (int i = 0; i < 5; ++i) {
                double d0 = player.field_6002.field_9229.nextGaussian() * 0.02;
                double d1 = player.field_6002.field_9229.nextGaussian() * 0.02;
                double d2 = player.field_6002.field_9229.nextGaussian() * 0.02;
                player.field_6002.method_8406(particleEffect, player.method_23322(1.0), player.method_23319() + 1.0, player.method_23325(1.0), d0, d1, d2);
            }
            tick = 0;
        }
    }
}

