/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage.component;

import com.tiviacz.warriorrage.component.ComponentUtils;
import com.tiviacz.warriorrage.component.IRage;
import com.tiviacz.warriorrage.config.WarriorRageConfig;
import dev.onyxstudios.cca.internal.entity.CardinalComponentsEntity;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class Rage
implements IRage {
    private static final UUID RAGE = UUID.fromString("6e982d48-e5e6-11ec-8fea-0242ac120002");
    public static final int DEFAULT_RAGE_DURATION = 20 * WarriorRageConfig.rageDuration;
    public static final int MAX_KILL_COUNT_CAP = WarriorRageConfig.maxKillCountCap;
    public static final double BASE_MULTIPLIER = WarriorRageConfig.bonusDamageMultiplier;
    private int rageDuration = 0;
    private int killCount = 0;
    private final class_1657 playerEntity;

    public Rage(class_1657 playerEntity) {
        this.playerEntity = playerEntity;
    }

    @Override
    public void startRage() {
        class_1322 attackDamageModifier = new class_1322(RAGE, "RageBonusDamage", this.calculateBonusDamage(this.killCount, BASE_MULTIPLIER), class_1322.class_1323.field_6328);
        class_1324 attribute = this.playerEntity.method_5996(class_5134.field_23721);
        if (attribute.method_6199(RAGE) != null) {
            if (attribute.method_6199(RAGE).method_6186() != attackDamageModifier.method_6186()) {
                attribute.method_6200(RAGE);
                attribute.method_26837(attackDamageModifier);
            }
        } else {
            attribute.method_26837(attackDamageModifier);
        }
    }

    @Override
    public boolean canStartRage() {
        return this.killCount >= WarriorRageConfig.minimalKillCount && this.getRemainingRageDuration() > 0;
    }

    public double calculateBonusDamage(int killCount, double multiplier) {
        return WarriorRageConfig.killIntervalBetweenNextBonus == 0 ? (double)killCount * multiplier : (double)(killCount / WarriorRageConfig.killIntervalBetweenNextBonus) * multiplier;
    }

    @Override
    public int getRemainingRageDuration() {
        return this.rageDuration;
    }

    @Override
    public int getCurrentKillCount() {
        return this.killCount;
    }

    @Override
    public void addKill(int count) {
        if (this.killCount + count <= MAX_KILL_COUNT_CAP) {
            this.killCount += count;
        }
        this.refreshRageDuration();
    }

    @Override
    public void decreaseRageDuration() {
        if (this.rageDuration > 0) {
            --this.rageDuration;
        }
        if (this.rageDuration == 0) {
            this.killCount = 0;
        }
    }

    @Override
    public void removeRageEffects() {
        if (this.playerEntity.method_5996(class_5134.field_23721).method_6199(RAGE) != null) {
            this.playerEntity.method_5996(class_5134.field_23721).method_6200(RAGE);
        }
    }

    @Override
    public void refreshRageDuration() {
        if (this.rageDuration < DEFAULT_RAGE_DURATION) {
            this.rageDuration = DEFAULT_RAGE_DURATION;
        }
    }

    @Override
    public void setKillCount(int count) {
        if (count > MAX_KILL_COUNT_CAP) {
            this.killCount = MAX_KILL_COUNT_CAP;
            this.refreshRageDuration();
        } else if (count >= 0) {
            this.killCount = count;
            if (count > 0) {
                this.refreshRageDuration();
            }
        }
    }

    @Override
    public void setRageDuration(int timeInTicks) {
        this.rageDuration = timeInTicks;
    }

    @Override
    public void sync() {
        this.syncWith((class_3222)this.playerEntity);
    }

    @Override
    public void syncToTracking(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(player.method_5628());
        buf.method_10812(ComponentUtils.RAGE.getId());
        this.writeSyncPacket(buf, player);
        for (class_3222 serverPlayer : PlayerLookup.tracking((class_1297)player)) {
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)CardinalComponentsEntity.PACKET_ID, (class_2540)buf);
        }
    }

    public void syncWith(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(player.method_5628());
        buf.method_10812(ComponentUtils.RAGE.getId());
        this.writeSyncPacket(buf, player);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CardinalComponentsEntity.PACKET_ID, (class_2540)buf);
    }

    public void readFromNbt(class_2487 tag) {
        this.killCount = tag.method_10550("KillCount");
        this.rageDuration = tag.method_10550("Duration");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("KillCount", this.killCount);
        tag.method_10569("Duration", this.rageDuration);
    }
}

