/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage.capability;

import com.tiviacz.warriorrage.WarriorRage;
import com.tiviacz.warriorrage.WarriorRageConfig;
import com.tiviacz.warriorrage.capability.CapabilityUtils;
import com.tiviacz.warriorrage.capability.IRage;
import com.tiviacz.warriorrage.network.SyncRageCapabilityClient;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class Rage
implements IRage {
    private static final UUID RAGE = UUID.fromString("6e982d48-e5e6-11ec-8fea-0242ac120002");
    public static final int DEFAULT_RAGE_DURATION = 20 * WarriorRageConfig.rageDuration;
    public static final int MAX_KILL_COUNT_CAP = WarriorRageConfig.maxKillCountCap;
    public static final double BASE_MULTIPLIER = WarriorRageConfig.bonusDamageMultiplier;
    private int rageDuration = 0;
    private int killCount = 0;
    private final Player playerEntity;

    public Rage(Player playerEntity) {
        this.playerEntity = playerEntity;
    }

    @Override
    public void startRage() {
        AttributeModifier attackDamageModifier = new AttributeModifier(RAGE, "RageBonusDamage", this.calculateBonusDamage(this.killCount, BASE_MULTIPLIER), AttributeModifier.Operation.ADDITION);
        AttributeInstance attribute = this.playerEntity.m_21051_(Attributes.f_22281_);
        if (attribute.m_22111_(RAGE) != null) {
            if (attribute.m_22111_(RAGE).m_22218_() != attackDamageModifier.m_22218_()) {
                attribute.m_22120_(RAGE);
                attribute.m_22125_(attackDamageModifier);
            }
        } else {
            attribute.m_22125_(attackDamageModifier);
        }
    }

    @Override
    public boolean canStartRage() {
        return this.killCount >= WarriorRageConfig.minimalKillCount && this.getRemainingRageDuration() > 0;
    }

    public double calculateBonusDamage(int killCount, double multiplier) {
        return WarriorRageConfig.killIntervalBetweenNextBonus == 0 ? (double)killCount * multiplier : (double)(killCount / WarriorRageConfig.killIntervalBetweenNextBonus) * multiplier;
    }

    @Override
    public int getRemainingRageDuration() {
        return this.rageDuration;
    }

    @Override
    public int getCurrentKillCount() {
        return this.killCount;
    }

    @Override
    public void addKill(int count) {
        if (this.killCount + count <= MAX_KILL_COUNT_CAP) {
            this.killCount += count;
        }
        this.refreshRageDuration();
    }

    @Override
    public void decreaseRageDuration() {
        if (this.rageDuration > 0) {
            --this.rageDuration;
        }
        if (this.rageDuration == 0) {
            this.killCount = 0;
        }
    }

    @Override
    public void removeRageEffects() {
        if (this.playerEntity.m_21051_(Attributes.f_22281_).m_22111_(RAGE) != null) {
            this.playerEntity.m_21051_(Attributes.f_22281_).m_22120_(RAGE);
        }
    }

    @Override
    public void refreshRageDuration() {
        if (this.rageDuration < DEFAULT_RAGE_DURATION) {
            this.rageDuration = DEFAULT_RAGE_DURATION;
        }
    }

    @Override
    public void setKillCount(int count) {
        if (count > MAX_KILL_COUNT_CAP) {
            this.killCount = MAX_KILL_COUNT_CAP;
            this.refreshRageDuration();
        } else if (count >= 0) {
            this.killCount = count;
            if (count > 0) {
                this.refreshRageDuration();
            }
        }
    }

    @Override
    public void setRageDuration(int timeInTicks) {
        this.rageDuration = timeInTicks;
    }

    @Override
    public void synchronise() {
        if (this.playerEntity != null && !this.playerEntity.f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)this.playerEntity;
            CapabilityUtils.getCapability((Player)serverPlayer).ifPresent(cap -> WarriorRage.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncRageCapabilityClient(this.killCount, this.rageDuration, serverPlayer.m_142049_())));
        }
    }

    @Override
    public void synchroniseToOthers(Player player) {
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
        }
    }

    @Override
    public CompoundTag saveTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("KillCount", this.killCount);
        tag.m_128405_("Duration", this.rageDuration);
        return tag;
    }

    @Override
    public void loadTag(CompoundTag compoundTag) {
        this.killCount = compoundTag.m_128451_("KillCount");
        this.rageDuration = compoundTag.m_128451_("Duration");
    }
}

