/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage;

import com.tiviacz.warriorrage.WarriorRageConfig;
import com.tiviacz.warriorrage.capability.CapabilityUtils;
import com.tiviacz.warriorrage.capability.IRage;
import com.tiviacz.warriorrage.capability.Rage;
import com.tiviacz.warriorrage.capability.RageCapability;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="warriorrage", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    private static int tick = 0;

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IRage.class);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            Rage travelersBackpack = new Rage((Player)event.getObject());
            event.addCapability(RageCapability.ID, RageCapability.createProvider(travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (CapabilityUtils.getCapability(player).isPresent()) {
                CapabilityUtils.getCapability(player).ifPresent(IRage::removeRageEffects);
                CapabilityUtils.getCapability(player).ifPresent(r -> r.setKillCount(0));
            }
            CapabilityUtils.synchronise(player);
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        CapabilityUtils.getCapability(oldPlayer).ifPresent(oldRage -> CapabilityUtils.getCapability(event.getPlayer()).ifPresent(newRage -> newRage.setKillCount(oldRage.getCurrentKillCount())));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Player) {
            CapabilityUtils.synchronise((Player)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof Player && !event.getTarget().f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)event.getTarget();
        }
    }

    @SubscribeEvent
    public static void playerAttackMob(LivingAttackEvent event) {
        IRage rage;
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && CapabilityUtils.getCapability(player = (Player)entity).isPresent() && (rage = (IRage)CapabilityUtils.getCapability(player).resolve().get()).getCurrentKillCount() >= Rage.MAX_KILL_COUNT_CAP) {
            event.getEntity().m_20254_(2);
        }
    }

    @SubscribeEvent
    public static void playerSlayMob(LivingDeathEvent event) {
        Entity entity;
        Player player;
        LazyOptional<IRage> rage;
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof Player && (rage = CapabilityUtils.getCapability(player = (Player)entity2)).isPresent() && (entity = event.getEntity()) instanceof Monster) {
            Monster monster = (Monster)entity;
            rage.ifPresent(r -> r.addKill(1));
            CapabilityUtils.synchronise(player);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        LazyOptional<IRage> rage = CapabilityUtils.getCapability(event.player);
        if (rage.isPresent()) {
            IRage irage = (IRage)rage.resolve().get();
            if (irage.canStartRage()) {
                ForgeEventHandler.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123744_, event.player);
                irage.startRage();
                irage.decreaseRageDuration();
            } else if (irage.getRemainingRageDuration() > 0 && irage.getCurrentKillCount() < WarriorRageConfig.minimalKillCount) {
                irage.decreaseRageDuration();
            } else {
                irage.removeRageEffects();
            }
        }
    }

    protected static void addParticlesAroundSelf(ParticleOptions particleOptions, Player player) {
        if (++tick == 50) {
            for (int i = 0; i < 5; ++i) {
                double d0 = player.f_19853_.f_46441_.m_188583_() * 0.02;
                double d1 = player.f_19853_.f_46441_.m_188583_() * 0.02;
                double d2 = player.f_19853_.f_46441_.m_188583_() * 0.02;
                player.f_19853_.m_7106_(particleOptions, player.m_20208_(1.0), player.m_20187_() + 1.0, player.m_20262_(1.0), d0, d1, d2);
            }
            tick = 0;
        }
    }
}

