/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="warriorrage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WarriorRageConfig {
    public static int minimalKillCount;
    public static int rageDuration;
    public static int maxKillCountCap;
    public static int killIntervalBetweenNextBonus;
    public static double bonusDamageMultiplier;
    public static boolean enableFireDamage;
    public static boolean renderRageOverlay;
    private static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    private static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == serverSpec) {
            WarriorRageConfig.bakeServerConfig();
        }
        if (configEvent.getConfig().getSpec() == clientSpec) {
            WarriorRageConfig.bakeClientConfig();
        }
    }

    public static void bakeServerConfig() {
        minimalKillCount = (Integer)WarriorRageConfig.SERVER.minimalKillCount.get();
        rageDuration = (Integer)WarriorRageConfig.SERVER.rageDuration.get();
        maxKillCountCap = (Integer)WarriorRageConfig.SERVER.maxKillCountCap.get();
        killIntervalBetweenNextBonus = (Integer)WarriorRageConfig.SERVER.killIntervalBetweenNextBonus.get();
        bonusDamageMultiplier = (Double)WarriorRageConfig.SERVER.bonusDamageMultiplier.get();
        enableFireDamage = (Boolean)WarriorRageConfig.SERVER.enableFireDamage.get();
    }

    public static void bakeCommonConfig() {
    }

    public static void bakeClientConfig() {
        renderRageOverlay = (Boolean)WarriorRageConfig.CLIENT.renderRageOverlay.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue minimalKillCount;
        public final ForgeConfigSpec.IntValue rageDuration;
        public final ForgeConfigSpec.IntValue maxKillCountCap;
        public final ForgeConfigSpec.IntValue killIntervalBetweenNextBonus;
        public final ForgeConfigSpec.DoubleValue bonusDamageMultiplier;
        public final ForgeConfigSpec.BooleanValue enableFireDamage;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server config settings").push("server");
            this.minimalKillCount = builder.comment("Minimal kill count for rage to enable").translation("warriorrage.config.server.minimalKillCount").defineInRange("minimalKillCount", 3, 0, 1000);
            this.rageDuration = builder.comment("In Seconds").translation("warriorrage.config.server.rageDuration").defineInRange("rageDuration", 20, 0, 1000);
            this.maxKillCountCap = builder.comment("Max kill count for rage bonus damage").translation("warriorrage.config.server.maxKillCountCap").defineInRange("maxKillCountCap", 20, 0, 1000);
            this.killIntervalBetweenNextBonus = builder.comment("Number of kills, which will multiply the bonus damage eg. 5 means, every 5 kills attack damage will be increased by bonusDamageMultiplier value").translation("warriorrage.config.server.killIntervalBetweenNextBonus").defineInRange("killIntervalBetweenNextBonus", 4, 1, 1000);
            this.bonusDamageMultiplier = builder.translation("Bonus damage per 4 kills in a row").translation("warriorrage.config.server.bonusDamageMultiplier").defineInRange("bonusDamageMultiplier", 0.5, 0.01, 10.0);
            this.enableFireDamage = builder.translation("Enable Fire Damage on full kill count").translation("warriorrage.config.server.enableFireDamage").define("enableFireDamage", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue renderRageOverlay;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.renderRageOverlay = builder.comment("Render Rage Overlay on experience bar").translation("warriorrage.config.client.renderRageOverlay").define("renderRageOverlay", true);
            builder.pop();
        }
    }
}

