/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage.network;

import com.tiviacz.warriorrage.capability.CapabilityUtils;
import com.tiviacz.warriorrage.capability.IRage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncRageCapabilityClient {
    private final int killCount;
    private final int remainingDuration;
    private final int entityID;

    public SyncRageCapabilityClient(int killCount, int remainingDuration, int entityID) {
        this.killCount = killCount;
        this.remainingDuration = remainingDuration;
        this.entityID = entityID;
    }

    public static SyncRageCapabilityClient decode(FriendlyByteBuf buffer) {
        int killCount = buffer.readInt();
        int remainingDuration = buffer.readInt();
        int entityID = buffer.readInt();
        return new SyncRageCapabilityClient(killCount, remainingDuration, entityID);
    }

    public static void encode(SyncRageCapabilityClient message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.killCount);
        buffer.writeInt(message.remainingDuration);
        buffer.writeInt(message.entityID);
    }

    public static void handle(SyncRageCapabilityClient message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Player playerEntity = (Player)Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(message.entityID);
            IRage cap = (IRage)CapabilityUtils.getCapability(playerEntity).orElse(null);
            if (cap != null) {
                cap.setKillCount(message.killCount);
                cap.setRageDuration(message.remainingDuration);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

