/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage.capability;

import com.tiviacz.warriorrage.capability.IRage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class RageCapability {
    public static final Capability<IRage> RAGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IRage>(){});
    public static final Direction DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("warriorrage", "warrior_rage");

    public static ICapabilityProvider createProvider(IRage backpack) {
        return new Provider(backpack);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        final IRage rage;
        final LazyOptional<IRage> optional;

        public Provider(IRage rage) {
            this.rage = rage;
            this.optional = LazyOptional.of(() -> rage);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return RAGE_CAPABILITY.orEmpty(cap, this.optional);
        }

        public CompoundTag serializeNBT() {
            return this.rage.saveTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.rage.loadTag(nbt);
        }
    }
}

