/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.warriorrage.WarriorRageConfig;
import com.tiviacz.warriorrage.capability.CapabilityUtils;
import com.tiviacz.warriorrage.capability.IRage;
import com.tiviacz.warriorrage.capability.Rage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="warriorrage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class RageOverlay {
    public static void renderRageBar(ForgeGui gui, PoseStack mStack, float partialTicks, int screenWidth, int screenHeight) {
        IRage rage;
        if (!WarriorRageConfig.renderRageOverlay) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        if (CapabilityUtils.getCapability((Player)player).isPresent() && (rage = CapabilityUtils.resolveCapability((Player)player)).canStartRage()) {
            ResourceLocation texture = new ResourceLocation("warriorrage", "textures/gui/warrior_rage_bar.png");
            float durationProgress = (float)rage.getRemainingRageDuration() / (float)Rage.DEFAULT_RAGE_DURATION;
            int k = (int)(durationProgress * 183.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
            gui.m_93228_(mStack, screenWidth / 2 - 91, screenHeight - 32 + 3, 0, 69, k, 5);
            gui.m_93228_(mStack, screenWidth / 2 + 94 + WarriorRageConfig.offsetX, screenHeight - 32 + 16 + WarriorRageConfig.offsetY, 0, 0, 14, 14);
            String s = "" + rage.getCurrentKillCount();
            int i1 = (screenWidth - gui.m_93082_().m_92895_(s)) / 2 + 115 + WarriorRageConfig.offsetX;
            int j1 = screenHeight - 31 + 18 + WarriorRageConfig.offsetY;
            gui.m_93082_().m_92883_(mStack, s, (float)(i1 + 1), (float)j1, 0);
            gui.m_93082_().m_92883_(mStack, s, (float)(i1 - 1), (float)j1, 0);
            gui.m_93082_().m_92883_(mStack, s, (float)i1, (float)(j1 + 1), 0);
            gui.m_93082_().m_92883_(mStack, s, (float)i1, (float)(j1 - 1), 0);
            gui.m_93082_().m_92883_(mStack, s, (float)i1, (float)j1, 0x611414);
        }
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent evt) {
        evt.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "warrior_rage", (gui, poseStack, partialTick, width, height) -> {
            Minecraft mc = Minecraft.m_91087_();
            if (!mc.f_91074_.m_108633_() && !mc.f_91066_.f_92062_) {
                RageOverlay.renderRageBar(gui, poseStack, partialTick, width, height);
            }
        });
    }
}

