/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.warriorrage;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="warriorrage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WarriorRageConfig {
    public static int minimalKillCount;
    public static int rageDuration;
    public static int maxKillCountCap;
    public static int killIntervalBetweenNextBonus;
    public static double bonusDamageMultiplier;
    public static boolean enableFireDamage;
    public static boolean renderRageOverlay;
    public static int offsetX;
    public static int offsetY;
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    private static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            WarriorRageConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == clientSpec) {
            WarriorRageConfig.bakeClientConfig();
        }
    }

    public static void bakeCommonConfig() {
        minimalKillCount = (Integer)WarriorRageConfig.COMMON.minimalKillCount.get();
        rageDuration = (Integer)WarriorRageConfig.COMMON.rageDuration.get();
        maxKillCountCap = (Integer)WarriorRageConfig.COMMON.maxKillCountCap.get();
        killIntervalBetweenNextBonus = (Integer)WarriorRageConfig.COMMON.killIntervalBetweenNextBonus.get();
        bonusDamageMultiplier = (Double)WarriorRageConfig.COMMON.bonusDamageMultiplier.get();
        enableFireDamage = (Boolean)WarriorRageConfig.COMMON.enableFireDamage.get();
    }

    public static void bakeClientConfig() {
        renderRageOverlay = (Boolean)WarriorRageConfig.CLIENT.renderRageOverlay.get();
        offsetX = (Integer)WarriorRageConfig.CLIENT.offsetX.get();
        offsetY = (Integer)WarriorRageConfig.CLIENT.offsetY.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue minimalKillCount;
        public final ForgeConfigSpec.IntValue rageDuration;
        public final ForgeConfigSpec.IntValue maxKillCountCap;
        public final ForgeConfigSpec.IntValue killIntervalBetweenNextBonus;
        public final ForgeConfigSpec.DoubleValue bonusDamageMultiplier;
        public final ForgeConfigSpec.BooleanValue enableFireDamage;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.minimalKillCount = builder.comment("Minimal kill count for rage to enable").translation("warriorrage.config.server.minimalKillCount").defineInRange("minimalKillCount", 3, 0, 1000);
            this.rageDuration = builder.comment("In Seconds").translation("warriorrage.config.server.rageDuration").defineInRange("rageDuration", 20, 0, 1000);
            this.maxKillCountCap = builder.comment("Max kill count for rage bonus damage").translation("warriorrage.config.server.maxKillCountCap").defineInRange("maxKillCountCap", 20, 0, 1000);
            this.killIntervalBetweenNextBonus = builder.comment("Number of kills, which will multiply the bonus damage eg. 5 means, every 5 kills attack damage will be increased by bonusDamageMultiplier value").translation("warriorrage.config.server.killIntervalBetweenNextBonus").defineInRange("killIntervalBetweenNextBonus", 4, 1, 1000);
            this.bonusDamageMultiplier = builder.translation("Bonus damage per 4 kills in a row").translation("warriorrage.config.server.bonusDamageMultiplier").defineInRange("bonusDamageMultiplier", 0.5, 0.01, 10.0);
            this.enableFireDamage = builder.translation("Enable Fire Damage on full kill count").translation("warriorrage.config.server.enableFireDamage").define("enableFireDamage", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue renderRageOverlay;
        public final ForgeConfigSpec.IntValue offsetX;
        public final ForgeConfigSpec.IntValue offsetY;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.renderRageOverlay = builder.comment("Render Rage Overlay on experience bar").translation("warriorrage.config.client.renderRageOverlay").define("renderRageOverlay", true);
            this.offsetX = builder.comment("Negative offsets to left side, positive to right").defineInRange("offsetX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.offsetY = builder.comment("Negative offsets to up, positive to down").defineInRange("offsetY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

