/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IPlayerModel;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float f) {
        super(context, entityModel, f);
    }

    @Inject(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private void hideBonesInFirstPerson(AbstractClientPlayer entity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo ci) {
        if (FirstPersonMode.isFirstPersonPass()) {
            AnimationApplier animationApplier = ((IAnimatedPlayer)entity).playerAnimator_getAnimation();
            FirstPersonConfiguration config = animationApplier.getFirstPersonConfiguration();
            if (entity == Minecraft.m_91087_().m_91288_()) {
                this.setAllPartsVisible(false);
                boolean showRightArm = config.isShowRightArm();
                boolean showLeftArm = config.isShowLeftArm();
                ((PlayerModel)this.f_115290_).f_102811_.f_104207_ = showRightArm;
                ((PlayerModel)this.f_115290_).f_103375_.f_104207_ = showRightArm;
                ((PlayerModel)this.f_115290_).f_102812_.f_104207_ = showLeftArm;
                ((PlayerModel)this.f_115290_).f_103374_.f_104207_ = showLeftArm;
            }
        }
    }

    @Unique
    private void setAllPartsVisible(boolean visible) {
        ((PlayerModel)this.f_115290_).f_102808_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_102810_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_102814_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_102813_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_102811_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_102812_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_102809_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_103374_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_103375_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_103376_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_103377_.f_104207_ = visible;
        ((PlayerModel)this.f_115290_).f_103378_.f_104207_ = visible;
    }

    @Inject(method={"setupRotations(Lnet/minecraft/client/player/AbstractClientPlayer;Lcom/mojang/blaze3d/vertex/PoseStack;FFF)V"}, at={@At(value="RETURN")})
    private void applyBodyTransforms(AbstractClientPlayer abstractClientPlayerEntity, PoseStack matrixStack, float f, float bodyYaw, float tickDelta, CallbackInfo ci) {
        AnimationApplier animationPlayer = ((IAnimatedPlayer)abstractClientPlayerEntity).playerAnimator_getAnimation();
        animationPlayer.setTickDelta(tickDelta);
        if (animationPlayer.isActive()) {
            Vec3f vec3d = animationPlayer.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
            matrixStack.m_85837_((double)((Float)vec3d.getX()).floatValue(), (double)((Float)vec3d.getY()).floatValue() + 0.7, (double)((Float)vec3d.getZ()).floatValue());
            Vec3f vec3f = animationPlayer.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122270_(((Float)vec3f.getZ()).floatValue()));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(((Float)vec3f.getY()).floatValue()));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122270_(((Float)vec3f.getX()).floatValue()));
            matrixStack.m_85837_(0.0, -0.7, 0.0);
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V")})
    private void notifyModelOfFirstPerson(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, ModelPart modelPart, ModelPart modelPart2, CallbackInfo ci) {
        EntityModel entityModel = this.m_7200_();
        if (entityModel instanceof IPlayerModel) {
            IPlayerModel playerModel = (IPlayerModel)entityModel;
            if (!((IAnimatedPlayer)abstractClientPlayer).playerAnimator_getAnimation().getFirstPersonMode().isEnabled()) {
                playerModel.playerAnimator_prepForFirstPersonRender();
            }
        }
    }
}

