/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.entities;

import com.aqutheseal.celestisynth.config.CSConfig;
import com.aqutheseal.celestisynth.entities.CSEffect;
import com.aqutheseal.celestisynth.entities.helper.CSEffectTypes;
import com.aqutheseal.celestisynth.item.CrescentiaItem;
import com.aqutheseal.celestisynth.item.helpers.CSWeapon;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;

public class CrescentiaRanged
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(CrescentiaRanged.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> ANGLE_X = SynchedEntityData.m_135353_(CrescentiaRanged.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_Y = SynchedEntityData.m_135353_(CrescentiaRanged.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_Z = SynchedEntityData.m_135353_(CrescentiaRanged.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_X = SynchedEntityData.m_135353_(CrescentiaRanged.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_Y = SynchedEntityData.m_135353_(CrescentiaRanged.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_Z = SynchedEntityData.m_135353_(CrescentiaRanged.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public CrescentiaRanged(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public void m_8119_() {
        Player player;
        super.m_8119_();
        UUID uuid = this.getOwnerUuid();
        Player player2 = player = uuid == null ? null : this.m_9236_().m_46003_(uuid);
        if (player == null || player.m_21224_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.setAngleX(this.getAngleX() + this.getAddAngleX());
        this.setAngleY(this.getAngleY() + this.getAddAngleY());
        this.setAngleZ(this.getAngleZ() + this.getAddAngleZ());
        double newX = this.m_20185_() + (double)this.getAngleX();
        double newY = this.m_20186_() + (double)this.getAngleY();
        double newZ = this.m_20189_() + (double)this.getAngleZ();
        BlockPos newPos = new BlockPos((int)newX, (int)newY, (int)newZ);
        double range = 7.0;
        List entities = this.f_19853_.m_45976_(Entity.class, new AABB(newX + range, newY + range, newZ + range, newX - range, newY - range, newZ - range));
        ItemStack stack = new ItemStack((ItemLike)Items.f_42688_);
        for (Entity entityBatch : entities) {
            LivingEntity target;
            if (entityBatch instanceof LivingEntity && (target = (LivingEntity)entityBatch) != player && target.m_6084_()) {
                double preAttribute = target.m_21051_(Attributes.f_22278_).m_22135_();
                target.m_21051_(Attributes.f_22278_).m_22100_(100.0);
                target.f_19802_ = 0;
                target.m_6469_(DamageSource.m_19344_((Player)player), ((Float)CSConfig.COMMON.crescentiaShiftSkillDmg.get()).floatValue());
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
                target.m_21051_(Attributes.f_22278_).m_22100_(preAttribute);
            }
            if (!(entityBatch instanceof Projectile)) continue;
            Projectile projectile = (Projectile)entityBatch;
            CrescentiaItem.createCrescentiaFirework(stack, this.f_19853_, player, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), true, this.f_19797_);
            projectile.m_5496_(SoundEvents.f_11932_, 1.0f, 1.0f);
            projectile.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (new Random().nextBoolean()) {
            CSEffect.createInstance(player, this, CSEffectTypes.CRESCENTIA_THROW, this.getAngleX(), (double)this.getAngleY() - 1.5, this.getAngleZ());
        } else {
            CSEffect.createInstance(player, this, CSEffectTypes.CRESCENTIA_THROW_INVERTED, this.getAngleX(), (double)this.getAngleY() - 1.5, this.getAngleZ());
        }
        CSEffect.createInstance(player, this, CSEffectTypes.SOLARIS_AIR, this.getAngleX(), this.getAngleY(), this.getAngleZ());
        this.playRandomBladeSound(CSWeapon.BASE_WEAPON_EFFECTS.length, newX, newY, newZ);
        int radius = 2;
        for (int sx = -radius; sx <= radius; ++sx) {
            for (int sy = -radius; sy <= radius; ++sy) {
                for (int sz = -radius; sz <= radius; ++sz) {
                    if (!this.m_9236_().m_8055_(newPos.m_7918_(sx, sy, sz)).m_204336_(BlockTags.f_198158_)) continue;
                    this.m_9236_().m_46953_(newPos.m_7918_(sx, sy, sz), false, (Entity)player);
                }
            }
        }
        if (this.f_19797_ == 100 || !this.m_9236_().m_8055_(newPos).m_60795_()) {
            this.f_19853_.m_46511_((Entity)player, newX, newY, newZ, 3.0f, Explosion.BlockInteraction.DESTROY);
            CrescentiaItem.createCrescentiaFirework(stack, this.f_19853_, player, newX, newY, newZ, true, this.f_19797_);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void playRandomBladeSound(int length, double x, double y, double z) {
        SoundEvent randomSound = CrescentiaItem.BASE_WEAPON_EFFECTS[new Random().nextInt(length)];
        this.f_19853_.m_6263_(this.f_19853_.m_46003_(this.getOwnerUuid()), x, y, z, randomSound, SoundSource.HOSTILE, 0.1f, 0.5f + new Random().nextFloat());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ANGLE_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_Z, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag tag) {
        UUID uuid;
        if (tag.m_128403_("Owner")) {
            uuid = tag.m_128342_("Owner");
        } else {
            String s = tag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUuid(uuid);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("...Crescentia-Ranged got no goddamn owner.");
            }
        }
        this.setAngleX(tag.m_128457_("cs.angleX"));
        this.setAngleY(tag.m_128457_("cs.angleY"));
        this.setAngleZ(tag.m_128457_("cs.angleZ"));
        this.setAddAngleX(tag.m_128457_("cs.angleAddX"));
        this.setAddAngleY(tag.m_128457_("cs.angleAddY"));
        this.setAddAngleZ(tag.m_128457_("cs.angleAddZ"));
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.getOwnerUuid() != null) {
            tag.m_128362_("Owner", this.getOwnerUuid());
        }
        tag.m_128350_("cs.angleX", this.getAngleX());
        tag.m_128350_("cs.angleY", this.getAngleY());
        tag.m_128350_("cs.angleZ", this.getAngleZ());
        tag.m_128350_("cs.angleAddX", this.getAddAngleX());
        tag.m_128350_("cs.angleAddY", this.getAddAngleY());
        tag.m_128350_("cs.angleAddZ", this.getAddAngleZ());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setOwnerUuid(@Nullable UUID ownerUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(ownerUuid));
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setAngleX(float angleX) {
        this.f_19804_.m_135381_(ANGLE_X, (Object)Float.valueOf(angleX));
    }

    public float getAngleX() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_X)).floatValue();
    }

    public void setAngleY(float angleY) {
        this.f_19804_.m_135381_(ANGLE_Y, (Object)Float.valueOf(angleY));
    }

    public float getAngleY() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_Y)).floatValue();
    }

    public void setAngleZ(float angleZ) {
        this.f_19804_.m_135381_(ANGLE_Z, (Object)Float.valueOf(angleZ));
    }

    public float getAngleZ() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_Z)).floatValue();
    }

    public void setAddAngleX(float angleX) {
        this.f_19804_.m_135381_(ANGLE_ADD_X, (Object)Float.valueOf(angleX));
    }

    public float getAddAngleX() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_X)).floatValue();
    }

    public void setAddAngleY(float angleY) {
        this.f_19804_.m_135381_(ANGLE_ADD_Y, (Object)Float.valueOf(angleY));
    }

    public float getAddAngleY() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_Y)).floatValue();
    }

    public void setAddAngleZ(float angleZ) {
        this.f_19804_.m_135381_(ANGLE_ADD_Z, (Object)Float.valueOf(angleZ));
    }

    public float getAddAngleZ() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_Z)).floatValue();
    }
}

