/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.entities.helper;

import com.aqutheseal.celestisynth.entities.CSEffect;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;

public enum CSEffectTypes {
    SOLARIS_BLITZ("solaris_spin", Model.FLAT, Animation.SPIN_15, 0, 0, 2.5, true, true, false),
    SOLARIS_BLITZ_SOUL("solaris_spin_soul", Model.FLAT, Animation.SPIN_15, 0, 0, 3.5, true, true, false),
    SOLARIS_AIR("solaris_air", Model.FLAT, Animation.SPIN_20, 0, 0, 2.5, true, true, false),
    SOLARIS_AIR_LARGE("solaris_air_large", "solaris_air", Model.FLAT, Animation.SPIN_20, 0, 0, 3.5, true, true, false),
    SOLARIS_AIR_FLAT("solaris_air_flat", "solaris_air", Model.FLAT, Animation.SPIN_20, 0, 0, 1.5, false, true, false),
    SOLARIS_AIR_MEDIUM_FLAT("solaris_air_medium_flat", "solaris_air", Model.FLAT, Animation.SPIN_20, 0, 0, 2.5, false, true, false),
    SOLARIS_AIR_LARGE_FLAT("solaris_air_large_flat", "solaris_air", Model.FLAT, Animation.SPIN_20, 0, 0, 3.5, false, true, false),
    CRESCENTIA_STRIKE("crescentia_strike", Model.FLAT, Animation.SWEEP_RTOL, 0, 0, 2.5, false, false, true),
    CRESCENTIA_STRIKE_INVERTED("crescentia_strike_inverted", "crescentia_strike", Model.FLAT, Animation.SWEEP_LTOR, 0, 0, 2.5, false, false, true),
    CRESCENTIA_THROW("crescentia_throw", Model.FLAT, Animation.SWEEP_RTOL, 0, 0, 3.0, false, true, true),
    CRESCENTIA_THROW_INVERTED("crescentia_throw_inverted", "crescentia_throw", Model.FLAT, Animation.SWEEP_LTOR, 0, 0, 3.0, false, true, true),
    BREEZEBREAKER_SLASH("breezebreaker_slash", Model.FLAT, Animation.SWEEP_RTOL, 0, 0, 3.0, false, true, true),
    BREEZEBREAKER_SLASH_INVERTED("breezebreaker_slash_inverted", "breezebreaker_slash", Model.FLAT, Animation.SWEEP_LTOR, 0, 0, 3.0, false, true, true),
    BREEZEBREAKER_WHEEL("breezebreaker_slash_vertical", "breezebreaker_wheel", Model.FLAT_VERTICAL_FRONTFACE, Animation.SWEEP_RTOL, 0, 0, 4.0, false, true, false),
    BREEZEBREAKER_DASH("breezebreaker_dash", Model.CROSS, Animation.STRETCH, 0, 0, 3.0, false, true, false),
    BREEZEBREAKER_DASH_2("breezebreaker_dash_2", Model.FLAT_VERTICAL_SIDEFACE, Animation.NONE_15, 0, 0, 4.0, false, true, false),
    BREEZEBREAKER_DASH_3("breezebreaker_dash_3", "breezebreaker_dash_2", Model.FLAT_VERTICAL_SIDEFACE, Animation.NONE_10, 0, 0, 2.0, false, true, false);

    final String name;
    final String texture;
    final Model model;
    final Animation animation;
    final int frames;
    final int framesSpeed;
    final double scale;
    final boolean rotateRandomly;
    final boolean fadeOut;
    final boolean specialProperties;

    private CSEffectTypes(String name, String texture, Model model, Animation animation, int frames, int framesSpeed, double scale, boolean rotateRandomly, boolean fadeOut, boolean specialProperties) {
        this.name = name;
        this.texture = texture;
        this.model = model;
        this.animation = animation;
        this.frames = frames;
        this.framesSpeed = framesSpeed;
        this.scale = scale;
        this.rotateRandomly = rotateRandomly;
        this.fadeOut = fadeOut;
        this.specialProperties = specialProperties;
    }

    private CSEffectTypes(String texture, Model model, Animation animation, int frames, int framesSpeed, double scale, boolean rotateRandomly, boolean fadeOut, boolean specialProperties) {
        this(texture, texture, model, animation, frames, framesSpeed, scale, rotateRandomly, fadeOut, specialProperties);
    }

    public String getName() {
        return this.name;
    }

    public String getTexture() {
        return this.texture;
    }

    public Model getModel() {
        return this.model;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public int getFrames() {
        return this.frames;
    }

    public int getFramesSpeed() {
        return this.framesSpeed;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isRotateRandomly() {
        return this.rotateRandomly;
    }

    public boolean isFadeOut() {
        return this.fadeOut;
    }

    public boolean hasSpecialProperties() {
        return this.specialProperties;
    }

    public static void setSpecialProperties(CSEffect animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        switch (animatable.getEffectType()) {
            case CRESCENTIA_STRIKE: 
            case CRESCENTIA_STRIKE_INVERTED: 
            case CRESCENTIA_THROW: 
            case CRESCENTIA_THROW_INVERTED: {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)animatable.getRotationZ() / 360.0f * 90.0f - 45.0f));
                break;
            }
            case BREEZEBREAKER_SLASH: 
            case BREEZEBREAKER_SLASH_INVERTED: {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)animatable.getRotationZ() / 360.0f * 45.0f - 22.5f));
                break;
            }
        }
    }

    public static enum Model {
        FLAT("cs_effect_flat"),
        FLAT_INVERTED("cs_effect_flat_inverted"),
        FLAT_VERTICAL_SIDEFACE("cs_effect_flat_vertical"),
        FLAT_VERTICAL_FRONTFACE("cs_effect_flat_vertical_side"),
        IMPACT("cs_effect_impact"),
        CROSS("cs_effect_cross");

        final String modelString;

        private Model(String model) {
            this.modelString = model;
        }

        public String getModelString() {
            return this.modelString;
        }
    }

    public static enum Animation {
        NONE_10("animation.cs_effect.none", 10),
        NONE_15("animation.cs_effect.none", 15),
        NONE_20("animation.cs_effect.none", 20),
        SPIN_15("animation.cs_effect.spin", 15),
        SPIN_20("animation.cs_effect.spin", 20),
        SMASH("animation.cs_effect.smash", 20),
        ASCEND("animation.cs_effect.ascend", 20),
        SLOW_ROTATION("animation.cs_effect.slow_rotation", Integer.MAX_VALUE),
        SWEEP_RTOL("animation.cs_effect.sweep_rtol", 15),
        SWEEP_LTOR("animation.cs_effect.sweep_ltor", 15),
        STRETCH("animation.cs_effect.stretch", 15);

        final String animationString;
        final int lifespan;

        private Animation(String animation, int lifespan) {
            this.animationString = animation;
            this.lifespan = lifespan;
        }

        public String getAnimationString() {
            return this.animationString;
        }

        public int getLifespan() {
            return this.lifespan;
        }
    }
}

