/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.entities.renderer;

import com.aqutheseal.celestisynth.config.CSConfig;
import com.aqutheseal.celestisynth.entities.CSEffect;
import com.aqutheseal.celestisynth.entities.helper.CSEffectTypes;
import com.aqutheseal.celestisynth.entities.model.CSEffectModel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoProjectilesRenderer;
import software.bernie.geckolib3.util.EModelRenderCycle;
import software.bernie.geckolib3.util.IRenderCycle;

public class CSEffectRenderer
extends GeoProjectilesRenderer<CSEffect> {
    public CSEffectRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new CSEffectModel());
    }

    public void renderEarly(CSEffect animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)animatable.f_19859_, (float)animatable.m_146908_()) - 165.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - lerpBodyRot));
        if (animatable.getEffectType().isRotateRandomly() && !animatable.getEffectType().hasSpecialProperties()) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_((float)animatable.getRotationX()));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)animatable.getRotationZ()));
        }
        CSEffectTypes.setSpecialProperties(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        super.renderEarly((Entity)animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(CSEffect animatable, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelResource((Object)animatable));
        this.dispatchedMat = poseStack.m_85850_().m_85861_().m_27658_();
        this.setCurrentModelRenderCycle((IRenderCycle)EModelRenderCycle.INITIAL);
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTick, (float)animatable.f_19860_, (float)animatable.m_146909_())));
        AnimationEvent predicate = new AnimationEvent((IAnimatable)animatable, 0.0f, 0.0f, partialTick, false, Collections.singletonList(new EntityModelData()));
        this.modelProvider.setLivingAnimations((IAnimatable)animatable, Integer.valueOf(this.getInstanceId(animatable)), predicate);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.m_5478_(animatable));
        Color renderColor = this.getRenderColor(animatable, partialTick, poseStack, bufferSource, null, packedLight);
        RenderType renderType = this.getRenderType(animatable, partialTick, poseStack, bufferSource, null, packedLight, this.m_5478_(animatable));
        if (!animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            this.render(model, (Object)animatable, partialTick, renderType, poseStack, bufferSource, null, packedLight, CSEffectRenderer.getPackedOverlay((Entity)animatable, (float)0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        poseStack.m_85849_();
        RenderNameTagEvent renderNameTagEvent = new RenderNameTagEvent((Entity)animatable, animatable.m_5446_(), (EntityRenderer)this, poseStack, bufferSource, packedLight, partialTick);
        MinecraftForge.EVENT_BUS.post((Event)renderNameTagEvent);
        if (renderNameTagEvent.getResult() != Event.Result.DENY && (renderNameTagEvent.getResult() == Event.Result.ALLOW || this.m_6512_(animatable))) {
            this.m_7649_(animatable, renderNameTagEvent.getContent(), poseStack, bufferSource, packedLight);
        }
    }

    public float getHeightScale(CSEffect entity) {
        float f = (float)((CSEffect)this.animatable).getEffectType().getScale();
        return super.getHeightScale((Entity)entity) * f;
    }

    public float getWidthScale(CSEffect animatable) {
        float f = (float)animatable.getEffectType().getScale();
        return super.getWidthScale((Entity)animatable) * f;
    }

    public RenderType getRenderType(CSEffect animatable, float partialTick, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, ResourceLocation texture) {
        return RenderType.m_234338_((ResourceLocation)texture);
    }

    protected int getBlockLightLevel(CSEffect p_114496_, BlockPos p_114497_) {
        return 15;
    }

    protected int getSkyLightLevel(CSEffect p_114509_, BlockPos p_114510_) {
        return 15;
    }

    public Color getRenderColor(CSEffect animatable, float partialTick, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight) {
        Minecraft mc = Minecraft.m_91087_();
        float decreasingAlpha = 1.0f;
        boolean shouldHideAtFirstPerson = false;
        if (animatable.getEffectType().isFadeOut()) {
            int lifespan = animatable.getEffectType().getAnimation().getLifespan();
            decreasingAlpha = 1.0f - (float)animatable.f_19797_ / (float)lifespan;
        }
        if (!((Boolean)CSConfig.CLIENT.visibilityOnFirstPerson.get()).booleanValue() && mc.f_91073_ != null && animatable.getOwnerUuid() != null && mc.f_91074_ != null && mc.f_91066_.m_92176_().m_90612_() && animatable.getOwnerUuid() == mc.f_91074_.m_20148_()) {
            shouldHideAtFirstPerson = true;
        }
        return Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)(shouldHideAtFirstPerson ? 0.0f : decreasingAlpha));
    }
}

