/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.item;

import com.aqutheseal.celestisynth.animation.AnimationManager;
import com.aqutheseal.celestisynth.config.CSConfig;
import com.aqutheseal.celestisynth.entities.BreezebreakerTornado;
import com.aqutheseal.celestisynth.entities.CSEffect;
import com.aqutheseal.celestisynth.entities.helper.CSEffectTypes;
import com.aqutheseal.celestisynth.item.helpers.CSUtilityFunctions;
import com.aqutheseal.celestisynth.item.helpers.CSWeapon;
import com.aqutheseal.celestisynth.registry.CSEntityRegistry;
import com.aqutheseal.celestisynth.registry.CSSoundRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;

public class BreezebreakerItem
extends SwordItem
implements CSWeapon {
    public static final String BB_COMBO_POINTS = "cs.attackIndex";
    public static final String AT_BUFF_STATE = "cs.buffState";
    public static final String BUFF_STATE_LIMITER = "cs.buffStateLimiter";
    public static final String ATTACK_INDEX = "cs.attackIndex";
    public static final String IS_SHIFT_RIGHT = "cs.isShiftRight";
    public static final int ATTACK_NORMAL_SINGLE = 0;
    public static final int ATTACK_NORMAL_DOUBLE = 1;
    public static final int ATTACK_SHIFT = 2;
    public static final int ATTACK_SPRINT = 3;
    public static final int ATTACK_MIDAIR = 4;

    public BreezebreakerItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    @Override
    public int getSkillsAmount() {
        return 5;
    }

    @Override
    public int getPassiveAmount() {
        return 2;
    }

    @Override
    public boolean hasPassive() {
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        CompoundTag itemTag = itemstack.m_41698_("csController");
        if (!player.m_36335_().m_41519_(itemstack.m_41720_()) && !itemTag.m_128471_("cs.hasAnimationBegun")) {
            if (player.m_6144_() && player.m_20096_()) {
                boolean isMainHandBreezebreaker = player.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof BreezebreakerItem;
                boolean isOffHandBreezebreaker = player.m_6844_(EquipmentSlot.OFFHAND).m_41720_() instanceof BreezebreakerItem;
                itemTag.m_128379_("cs.hasAnimationBegun", true);
                this.addComboPoint(itemstack, player);
                itemTag.m_128405_("cs.attackIndex", 2);
                if (hand == InteractionHand.MAIN_HAND && !isOffHandBreezebreaker) {
                    AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_SHIFT_RIGHT);
                    itemTag.m_128379_(IS_SHIFT_RIGHT, true);
                } else if (hand == InteractionHand.OFF_HAND && !isMainHandBreezebreaker) {
                    AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_SHIFT_LEFT);
                    itemTag.m_128379_(IS_SHIFT_RIGHT, false);
                } else if (isMainHandBreezebreaker || isOffHandBreezebreaker) {
                    boolean shouldShiftRight = level.f_46441_.m_188499_();
                    if (shouldShiftRight) {
                        AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_SHIFT_RIGHT);
                    } else {
                        AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_SHIFT_LEFT);
                    }
                    itemTag.m_128379_(IS_SHIFT_RIGHT, shouldShiftRight);
                }
                this.useAndDamageItem(itemstack, level, player, 3);
                player.m_36335_().m_41524_(itemstack.m_41720_(), this.buffStateModified(itemstack, 35));
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
            if (player.m_20142_() && player.m_20096_()) {
                itemTag.m_128379_("cs.hasAnimationBegun", true);
                this.addComboPoint(itemstack, player);
                itemTag.m_128405_("cs.attackIndex", 3);
                AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_SPRINT_ATTACK);
                this.useAndDamageItem(itemstack, level, player, 5);
                player.m_36335_().m_41524_(itemstack.m_41720_(), this.buffStateModified(itemstack, 15));
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
            if (!player.m_20096_()) {
                itemTag.m_128379_("cs.hasAnimationBegun", true);
                this.addComboPoint(itemstack, player);
                itemTag.m_128405_("cs.attackIndex", 4);
                AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_JUMP_ATTACK);
                this.useAndDamageItem(itemstack, level, player, 2);
                player.m_36335_().m_41524_(itemstack.m_41720_(), this.buffStateModified(itemstack, 40));
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
        }
        if (player.m_36335_().m_41519_(itemstack.m_41720_()) || itemTag.m_128471_("cs.hasAnimationBegun")) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(ItemStack itemstack, @NotNull Level level, @NotNull LivingEntity entity, int i) {
        CompoundTag itemTag = itemstack.m_41698_("csController");
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int dur = this.m_8105_(itemstack) - i;
            if (dur >= 0) {
                itemTag.m_128379_("cs.hasAnimationBegun", true);
                this.addComboPoint(itemstack, player);
                if (dur < 10) {
                    AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_NORMAL_SINGLE);
                    itemTag.m_128405_("cs.attackIndex", 0);
                } else {
                    AnimationManager.playAnimation(level, AnimationManager.AnimationsList.ANIM_BREEZEBREAKER_NORMAL_DOUBLE);
                    itemTag.m_128405_("cs.attackIndex", 1);
                }
                int cooldown = switch (itemTag.m_128451_("cs.attackIndex")) {
                    case 0 -> this.buffStateModified(itemstack, 15);
                    case 1 -> this.buffStateModified(itemstack, 20);
                    default -> throw new IllegalStateException("Unexpected value: " + itemTag.m_128451_("cs.attackIndex"));
                };
                this.useAndDamageItem(itemstack, level, player, 1);
                player.m_36335_().m_41524_(itemstack.m_41720_(), cooldown);
            }
        }
    }

    public void m_6883_(ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        CompoundTag data = itemStack.m_41698_("csController");
        CompoundTag data1 = itemStack.m_41698_("csExtras");
        if (entity instanceof Player) {
            player = (Player)entity;
            if (isSelected || player.m_21206_().m_41720_() instanceof BreezebreakerItem) {
                this.sendExpandingParticles(level, (ParticleType)ParticleTypes.f_123810_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.1f);
            }
        }
        if (data.m_128471_("cs.hasAnimationBegun") && entity instanceof Player) {
            player = (Player)entity;
            int animationTimer = data.m_128451_("cs.animationTimer");
            data.m_128405_("cs.animationTimer", animationTimer + 1);
            switch (data.m_128451_("cs.attackIndex")) {
                case 0: 
                case 1: {
                    this.tickNormalAttack(itemStack, level, player, animationTimer);
                    break;
                }
                case 2: {
                    this.tickShiftAttack(itemStack, level, player, animationTimer);
                    break;
                }
                case 3: {
                    this.tickDashAttack(itemStack, level, player, animationTimer);
                    break;
                }
                case 4: {
                    this.tickMidairAttack(itemStack, level, player, animationTimer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + data.m_128451_("cs.attackIndex"));
                }
            }
        }
        if (data1.m_128471_(AT_BUFF_STATE)) {
            if (entity instanceof Player) {
                player = (Player)entity;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 2, 1));
                for (int i = 0; i < 45; ++i) {
                    Vec3 lookDirection = player.m_20154_().m_82541_();
                    double offGlobal = 0.0;
                    double offX = offGlobal + lookDirection.m_7096_() * -1.0;
                    double offY = offGlobal + lookDirection.m_7098_() * -1.0;
                    double offZ = offGlobal + lookDirection.m_7094_() * -1.0;
                    CSUtilityFunctions.sendParticles(level, ParticleTypes.f_123759_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 0, offX, offY, offZ);
                }
            }
            data1.m_128405_(BUFF_STATE_LIMITER, data1.m_128451_(BUFF_STATE_LIMITER) + 1);
            if (data1.m_128451_(BUFF_STATE_LIMITER) >= 200) {
                data1.m_128379_(AT_BUFF_STATE, false);
                data1.m_128405_("cs.attackIndex", 0);
                data1.m_128405_(BUFF_STATE_LIMITER, 0);
            }
        }
    }

    public void tickNormalAttack(ItemStack itemStack, Level level, Player player, int animationTimer) {
        CompoundTag data = itemStack.m_41698_("csController");
        if (animationTimer == 6 || animationTimer == 11 && data.m_128451_("cs.attackIndex") == 1) {
            double range = 6.0;
            double rangeSq = Mth.m_144952_((double)range);
            List entities = level.m_45976_(Entity.class, player.m_20191_().m_82377_(range, range, range).m_82386_(this.calculateXLook(player), 0.0, this.calculateZLook(player)));
            for (Entity entityBatch : entities) {
                LivingEntity target;
                if (!(entityBatch instanceof LivingEntity) || (target = (LivingEntity)entityBatch) == player || !target.m_6084_() || player.m_7307_((Entity)target) || !(target.m_20280_((Entity)player) < rangeSq)) continue;
                this.constantAttack(player, target, ((Float)CSConfig.COMMON.breezebreakerSkillDmg.get()).floatValue() + (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)itemStack));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 1));
                this.sendExpandingParticles(level, (ParticleType)ParticleTypes.f_123759_, target.m_20183_().m_7494_(), 15, 0.0f);
            }
            player.m_216990_((SoundEvent)CSSoundRegistry.CS_WIND_STRIKE.get());
            if (data.m_128451_("cs.attackIndex") == 0) {
                CSEffect.createInstance(player, null, CSEffectTypes.BREEZEBREAKER_SLASH, this.calculateXLook(player), 0.0, this.calculateZLook(player));
                player.m_5496_((SoundEvent)CSSoundRegistry.CS_AIR_SWING.get(), 1.0f, 1.0f);
            } else if (data.m_128451_("cs.attackIndex") == 1) {
                CSEffect.createInstance(player, null, CSEffectTypes.BREEZEBREAKER_SLASH_INVERTED, this.calculateXLook(player), 0.0, this.calculateZLook(player));
                player.m_5496_((SoundEvent)CSSoundRegistry.CS_AIR_SWING.get(), 1.0f, 2.0f);
            }
        }
        if (animationTimer >= 15 && data.m_128451_("cs.attackIndex") == 0) {
            data.m_128405_("cs.animationTimer", 0);
            data.m_128379_("cs.hasAnimationBegun", false);
        }
        if (animationTimer >= 20 && data.m_128451_("cs.attackIndex") == 1) {
            data.m_128405_("cs.animationTimer", 0);
            data.m_128379_("cs.hasAnimationBegun", false);
        }
    }

    public void tickShiftAttack(ItemStack itemStack, Level level, Player player, int animationTimer) {
        CompoundTag data = itemStack.m_41698_("csController");
        if (animationTimer == 10) {
            player.m_216990_((SoundEvent)CSSoundRegistry.CS_WIND_STRIKE.get());
            player.m_216990_((SoundEvent)CSSoundRegistry.CS_WHIRLWIND.get());
            if (!level.m_5776_()) {
                BreezebreakerTornado projectile = (BreezebreakerTornado)((EntityType)CSEntityRegistry.BREEZEBREAKER_TORNADO.get()).m_20615_(level);
                projectile.setOwnerUuid(player.m_20148_());
                projectile.setAngleX((float)this.calculateXLook(player));
                projectile.setAngleY((float)this.calculateYLook(player));
                projectile.setAngleZ((float)this.calculateZLook(player));
                projectile.setAddAngleX((float)this.calculateXLook(player));
                projectile.setAddAngleY((float)this.calculateYLook(player));
                projectile.setAddAngleZ((float)this.calculateZLook(player));
                projectile.m_6027_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                level.m_7967_((Entity)projectile);
            }
        }
        if (animationTimer >= 20) {
            data.m_128405_("cs.animationTimer", 0);
            data.m_128379_("cs.hasAnimationBegun", false);
        }
    }

    public void tickDashAttack(ItemStack itemStack, Level level, Player player, int animationTimer) {
        CompoundTag data = itemStack.m_41698_("csController");
        if (animationTimer == 10) {
            LivingEntity living;
            this.sendExpandingParticles(level, (ParticleType)ParticleTypes.f_123777_, player.m_20183_(), 45, 0.2f);
            LivingEntity livingEntity = living = this.getLookAtEntity(player, 16.0) instanceof LivingEntity ? (LivingEntity)this.getLookAtEntity(player, 16.0) : null;
            if (living != null) {
                float attackDamage = ((Float)CSConfig.COMMON.breezebreakerSprintSkillDmg.get()).floatValue() + (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)itemStack);
                this.constantAttack(player, living, attackDamage);
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 2));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
                this.sendExpandingParticles(level, (ParticleType)ParticleTypes.f_123815_, player.m_20183_().m_7494_(), 45, 0.2f);
            }
            double speed = 7.0;
            float distii = 0.0f;
            while ((double)distii < speed) {
                BlockPos newPos = new BlockPos(player.m_20185_() + this.calculateXLook(player) * (double)distii, player.m_20186_(), player.m_20189_() + this.calculateZLook(player) * (double)distii);
                if (!level.m_46859_(newPos)) {
                    speed = distii;
                    break;
                }
                distii += 0.25f;
            }
            Vec3 delta = new Vec3(this.calculateXLook(player) * speed, 0.0, this.calculateZLook(player) * speed);
            player.m_6027_(player.m_20185_() + this.calculateXLook(player) * speed, player.m_20186_(), player.m_20189_() + this.calculateZLook(player) * speed);
            double[] multipliers = new double[]{2.0, 1.5, 1.0, 0.5, 0.0};
            CSEffectTypes[] effectTypes = new CSEffectTypes[]{CSEffectTypes.BREEZEBREAKER_DASH, CSEffectTypes.BREEZEBREAKER_DASH_2, CSEffectTypes.BREEZEBREAKER_DASH_3, CSEffectTypes.BREEZEBREAKER_DASH_3, CSEffectTypes.BREEZEBREAKER_DASH_3};
            for (int i = 0; i < multipliers.length; ++i) {
                boolean yOffset = i > 1;
                CSEffect.createInstance(player, null, effectTypes[i], delta.m_7096_() * multipliers[i], (double)yOffset, delta.m_7094_() * multipliers[i]);
            }
            player.m_5496_(SoundEvents.f_11913_, 1.0f, 1.5f);
            player.m_5496_((SoundEvent)CSSoundRegistry.CS_IMPACT_HIT.get(), 1.0f, 1.0f);
            player.m_5496_((SoundEvent)CSSoundRegistry.CS_STEP.get(), 1.0f, 1.0f);
        }
        if (animationTimer >= 20) {
            data.m_128405_("cs.animationTimer", 0);
            data.m_128379_("cs.hasAnimationBegun", false);
        }
    }

    public void tickMidairAttack(ItemStack itemStack, Level level, Player player, int animationTimer) {
        CompoundTag data = itemStack.m_41698_("csController");
        if (animationTimer == 10) {
            double range = 7.5;
            double rangeSq = Mth.m_144952_((double)range);
            List entities = level.m_45976_(Entity.class, player.m_20191_().m_82377_(range, range, 2.0));
            for (Entity entityBatch : entities) {
                LivingEntity target;
                if (!(entityBatch instanceof LivingEntity) || (target = (LivingEntity)entityBatch) == player || !target.m_6084_() || player.m_7307_((Entity)target) || !(target.m_20280_((Entity)player) < rangeSq)) continue;
                this.constantAttack(player, target, ((Float)CSConfig.COMMON.breezebreakerSprintSkillDmg.get()).floatValue() + (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)itemStack));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 1));
                this.sendExpandingParticles(level, (ParticleType)ParticleTypes.f_123759_, target.m_20183_().m_7494_(), 45, 0.0f);
            }
            CSEffect.createInstance(player, null, CSEffectTypes.BREEZEBREAKER_WHEEL, 0.0, -1.0, 0.0);
            player.m_5496_((SoundEvent)CSSoundRegistry.CS_FIRE_SHOOT.get(), 1.0f, 1.0f);
            player.m_5496_((SoundEvent)CSSoundRegistry.CS_AIR_SWING.get(), 1.0f, 1.0f);
            player.m_216990_((SoundEvent)CSSoundRegistry.CS_WIND_STRIKE.get());
            this.sendExpandingParticles(level, (ParticleType)ParticleTypes.f_123810_, player.m_20183_().m_7494_(), 75, 0.0f);
        }
        if (animationTimer >= 25) {
            data.m_128405_("cs.animationTimer", 0);
            data.m_128379_("cs.hasAnimationBegun", false);
        }
    }

    public void addComboPoint(ItemStack itemStack, Player player) {
        CompoundTag data1 = itemStack.m_41698_("csExtras");
        if (data1.m_128451_("cs.attackIndex") < 15) {
            player.m_216990_(SoundEvents.f_11871_);
            data1.m_128405_("cs.attackIndex", data1.m_128451_("cs.attackIndex") + 1);
        } else {
            player.m_216990_(SoundEvents.f_11880_);
            data1.m_128379_(AT_BUFF_STATE, !data1.m_128471_(AT_BUFF_STATE));
            data1.m_128405_("cs.attackIndex", 0);
        }
    }

    public int buffStateModified(ItemStack itemStack, int originalValue) {
        CompoundTag data1 = itemStack.m_41698_("csExtras");
        if (data1.m_128471_(AT_BUFF_STATE)) {
            return originalValue / 2;
        }
        return originalValue;
    }

    @Override
    public void onPlayerHurt(LivingHurtEvent event, ItemStack mainHandItem, ItemStack offHandItem) {
        if (event.getSource() == DamageSource.f_19315_) {
            event.setCanceled(true);
        } else {
            event.setAmount(event.getAmount() * 2.3f);
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }
}

