/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.registry;

import com.aqutheseal.celestisynth.block.SolarCrystalBlock;
import com.aqutheseal.celestisynth.registry.CSCreativeTabRegistry;
import com.aqutheseal.celestisynth.registry.CSItemRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CSBlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"celestisynth");
    public static final RegistryObject<Block> SOLAR_CRYSTAL = CSBlockRegistry.registerBlock("solar_crystal", () -> new SolarCrystalBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60918_(SoundType.f_56744_).m_60999_().m_60913_(3.0f, 9.0f).m_60955_().m_60991_((a, b, c) -> true).m_60953_(a -> 15)));
    public static final RegistryObject<Block> LUNAR_STONE = CSBlockRegistry.registerBlock("lunar_stone", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76415_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(4.0f, 9.0f).m_60953_(a -> 3)));
    public static final RegistryObject<Block> ZEPHYR_DEPOSIT = CSBlockRegistry.registerBlock("zephyr_deposit", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76385_).m_60918_(SoundType.f_56730_).m_60999_().m_60913_(60.5f, 9.0f).m_60953_(a -> 3)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        CSBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return CSItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(CSCreativeTabRegistry.CELESTISYNTH)));
    }
}

