/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.registry.datagen;

import com.aqutheseal.celestisynth.registry.CSBlockRegistry;
import com.aqutheseal.celestisynth.registry.CSItemRegistry;
import java.util.Collection;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CSItemModelProvider
extends ItemModelProvider {
    public CSItemModelProvider(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        this.defaultItem(CSItemRegistry.ITEMS.getEntries());
        this.csSinglePredicatedModel(CSItemRegistry.SOLARIS, "item/long_blade", this.csLoc("soul"), "item/long_blade");
        this.csCustomModel(CSItemRegistry.CRESCENTIA, this.getCSLoc("item/long_blade"));
        this.csCustomModel(CSItemRegistry.BREEZEBREAKER, this.getCSLoc("item/long_blade"));
        this.csCustomModel(((Block)CSBlockRegistry.SOLAR_CRYSTAL.get()).m_5456_(), this.getMcLoc("item/generated"));
        this.block(CSBlockRegistry.LUNAR_STONE);
        this.block(CSBlockRegistry.ZEPHYR_DEPOSIT);
    }

    public void defaultItem(Collection<RegistryObject<Item>> items) {
        for (RegistryObject<Item> item : items) {
            ModelFile.ExistingModelFile modelType;
            String name = item.getId().m_135815_();
            Item getItem = (Item)item.get();
            ResourceLocation datagenLoc = new ResourceLocation("celestisynth", "item/" + name);
            ModelFile.ExistingModelFile existingModelFile = modelType = getItem instanceof DiggerItem || getItem instanceof SwordItem ? this.getMcLoc("item/handheld") : this.getMcLoc("item/generated");
            if (getItem instanceof BlockItem) {
                return;
            }
            if (!this.existingFileHelper.exists(datagenLoc, (ExistingFileHelper.IResourceType)TEXTURE) && this.existingFileHelper.exists(datagenLoc, (ExistingFileHelper.IResourceType)MODEL)) continue;
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)modelType)).texture("layer0", "item/" + name);
        }
    }

    public void block(RegistryObject<Block> blockItem) {
        String name = blockItem.getId().m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getCSLoc("block/" + name));
    }

    public void csCustomModel(RegistryObject<Item> item, ModelFile.ExistingModelFile modelPath) {
        this.csCustomModel((Item)item.get(), modelPath);
    }

    public void csCustomModel(Item item, ModelFile.ExistingModelFile modelType) {
        String name = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)modelType)).texture("layer0", "item/" + name);
    }

    public void csSinglePredicatedModel(RegistryObject<Item> item, String modelPath, ResourceLocation predicate, String predicatedModelPath) {
        String name = item.getId().m_135815_();
        ModelFile.ExistingModelFile modelType = this.getCSLoc(modelPath);
        ModelFile.ExistingModelFile predModelType = this.getCSLoc(predicatedModelPath);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)modelType)).texture("layer0", "item/" + name)).override().predicate(predicate, 1.0f).model((ModelFile)this.getBuilder(name + "_" + predicate.m_135815_()));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name + "_" + predicate.m_135815_())).parent((ModelFile)predModelType)).texture("layer0", "item/" + name + "_" + predicate.m_135815_());
    }

    public ModelFile.ExistingModelFile getMcLoc(String mcModel) {
        return this.getExistingFile(this.mcLoc(mcModel));
    }

    public ModelFile.ExistingModelFile getCSLoc(String csModel) {
        return this.getExistingFile(this.csLoc(csModel));
    }

    public ResourceLocation csLoc(String name) {
        return new ResourceLocation("celestisynth", name);
    }
}

