/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.world.feature;

import com.aqutheseal.celestisynth.registry.CSBlockRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class ZephyrDepositFeature
extends Feature<NoneFeatureConfiguration> {
    public ZephyrDepositFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource randomsource = context.m_225041_();
        BlockPos pos = context.m_159777_();
        boolean large = randomsource.m_188503_(5) == 0;
        int tipMin = (int)((double)(large ? 25 : 10) * 0.4);
        int tipRand = (int)((double)(large ? 35 : 20) * 0.2);
        int radiusMin = large ? 5 : 3;
        int radiusRand = large ? 3 : 1;
        pos = new BlockPos(pos.m_123341_(), 2, pos.m_123343_());
        while (worldgenlevel.m_46859_(pos) && pos.m_123342_() < 100) {
            pos = pos.m_7494_();
        }
        if (worldgenlevel.m_8055_(pos.m_7495_()).m_60795_()) {
            return false;
        }
        int tip = tipMin + worldgenlevel.m_213780_().m_188503_(tipRand);
        int topX = worldgenlevel.m_213780_().m_188503_(tip) - tip / 2;
        int topZ = worldgenlevel.m_213780_().m_188503_(tip) - tip / 2;
        int radius = radiusMin + worldgenlevel.m_213780_().m_188503_(radiusRand);
        Vec3 to = new Vec3((double)(pos.m_123341_() + topX), (double)(pos.m_123342_() + tip), (double)(pos.m_123343_() + topZ));
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Vec3 from;
                double fromCenter = Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
                if (!(fromCenter <= (double)radius) || worldgenlevel.m_8055_(this.posFromVec(from = new Vec3((double)(pos.m_123341_() + x), (double)pos.m_123342_(), (double)(pos.m_123343_() + z))).m_7495_()).m_60795_()) continue;
                Vec3 per = to.m_82546_(from).m_82541_();
                Vec3 current = from.m_82520_(0.0, 0.0, 0.0);
                double distance = from.m_82554_(to);
                for (double i = 0.0; i < distance; i += 1.0) {
                    BlockPos targetPos = this.posFromVec(current);
                    worldgenlevel.m_7731_(targetPos, ((Block)CSBlockRegistry.ZEPHYR_DEPOSIT.get()).m_49966_(), 3);
                    current = current.m_82549_(per);
                }
            }
        }
        return true;
    }

    public BlockPos posFromVec(Vec3 vec3) {
        return new BlockPos((int)vec3.m_7096_(), (int)vec3.m_7098_(), (int)vec3.m_7094_());
    }
}

