/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.animation;

import com.aqutheseal.celestisynth.animation.CSAnimator;
import com.aqutheseal.celestisynth.network.CSNetwork;
import com.aqutheseal.celestisynth.network.animation.SetAnimationServerPacket;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class AnimationManager {
    public static int animIndex;

    public static void playAnimation(Level level, AnimationsList animation) {
        if (level.m_5776_()) {
            AnimationManager.playAnimation(animation, false);
        }
    }

    public static void playAnimation(AnimationsList animation) {
        AnimationManager.playAnimation(animation, false);
    }

    public static void playAnimation(AnimationsList animation, boolean isOtherLayer) {
        CSNetwork.sendToServer(new SetAnimationServerPacket(isOtherLayer, animation.getId()));
    }

    public static void playAnimation(@Nullable KeyframeAnimation animation, ModifierLayer<IAnimation> layer) {
        if (animation == null) {
            layer.setAnimation(null);
        } else {
            if (CSAnimator.animationData.containsValue(layer)) {
                layer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)10, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(animation).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(true).setShowRightItem(true).setShowLeftArm(true).setShowLeftItem(true)), true);
            }
            if (CSAnimator.otherAnimationData.containsValue(layer)) {
                layer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)10, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(animation).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(false).setShowRightItem(true).setShowLeftArm(false).setShowLeftItem(true)), true);
            }
        }
    }

    public static AnimationsList getAnimFromId(int id) {
        for (AnimationsList anim : AnimationsList.values()) {
            if (anim.id != id) continue;
            return anim;
        }
        throw new IllegalStateException("Animation ID is invalid: " + id);
    }

    public static enum AnimationsList {
        CLEAR(null),
        ANIM_SOLARIS_SPIN("cs_solaris_spin"),
        ANIM_CRESCENTIA_STRIKE("cs_crescentia_strike"),
        ANIM_CRESCENTIA_THROW("cs_crescentia_throw"),
        ANIM_BREEZEBREAKER_NORMAL_SINGLE("cs_breezebreaker_normal_single"),
        ANIM_BREEZEBREAKER_NORMAL_DOUBLE("cs_breezebreaker_normal_double"),
        ANIM_BREEZEBREAKER_SHIFT_RIGHT("cs_breezebreaker_shift_right"),
        ANIM_BREEZEBREAKER_SHIFT_LEFT("cs_breezebreaker_shift_left"),
        ANIM_BREEZEBREAKER_JUMP("cs_breezebreaker_jump"),
        ANIM_BREEZEBREAKER_JUMP_ATTACK("cs_breezebreaker_jump_attack"),
        ANIM_BREEZEBREAKER_SPRINT_ATTACK("cs_breezebreaker_sprint_attack");

        @Nullable
        final String path;
        final int id;

        private AnimationsList(String file) {
            this.path = file;
            this.id = animIndex++;
        }

        @Nullable
        public KeyframeAnimation getAnimation() {
            if (this.getPath() != null) {
                return PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("celestisynth", this.getPath()));
            }
            return null;
        }

        @Nullable
        public String getPath() {
            return this.path;
        }

        public int getId() {
            return this.id;
        }
    }
}

