/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.entities;

import com.aqutheseal.celestisynth.Celestisynth;
import com.aqutheseal.celestisynth.entities.helper.CSEffectTypes;
import com.aqutheseal.celestisynth.registry.CSEntityRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CSEffect
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(CSEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> TYPE_ID = SynchedEntityData.m_135353_(CSEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> FRAME_LEVEL = SynchedEntityData.m_135353_(CSEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SET_ROT_X = SynchedEntityData.m_135353_(CSEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SET_ROT_Z = SynchedEntityData.m_135353_(CSEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final RawAnimation RAW_ANIM = RawAnimation.begin();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Entity toFollow;
    public int lifespan;
    public int frameTimer;

    public CSEffect(EntityType<? extends CSEffect> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19811_ = true;
    }

    public CSEffectTypes getEffectType() {
        for (CSEffectTypes candids : CSEffectTypes.values()) {
            if (!candids.getName().equals(this.getTypeID())) continue;
            return candids;
        }
        return this.getDefaultEffect();
    }

    public void setEffectType(CSEffectTypes getEffectType) {
        this.setTypeID(getEffectType.getName());
    }

    public String getTypeID() {
        return (String)this.f_19804_.m_135370_(TYPE_ID);
    }

    public void setTypeID(String value) {
        this.f_19804_.m_135381_(TYPE_ID, (Object)value);
    }

    public int getFrameLevel() {
        return (Integer)this.f_19804_.m_135370_(FRAME_LEVEL);
    }

    public void setFrameLevel(int value) {
        this.f_19804_.m_135381_(FRAME_LEVEL, (Object)value);
    }

    public void setRotationX(int rotationX) {
        this.f_19804_.m_135381_(SET_ROT_X, (Object)rotationX);
    }

    public void setRotationZ(int rotationZ) {
        this.f_19804_.m_135381_(SET_ROT_Z, (Object)rotationZ);
    }

    public int getRotationX() {
        return (Integer)this.f_19804_.m_135370_(SET_ROT_X);
    }

    public int getRotationZ() {
        return (Integer)this.f_19804_.m_135370_(SET_ROT_Z);
    }

    public void setOwnerUuid(@Nullable UUID ownerUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(ownerUuid));
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public Entity getToFollow() {
        return this.toFollow;
    }

    public void setToFollow(Entity livingEntity) {
        this.toFollow = livingEntity;
    }

    public void setLifespan(int value) {
        this.lifespan = value;
    }

    public static CSEffect getEffectInstance(Player owner, @Nullable Entity toFollow, CSEffectTypes effectTypes, double offsetX, double offsetY, double offsetZ) {
        if (owner == null) {
            return null;
        }
        CSEffect slash = (CSEffect)((EntityType)CSEntityRegistry.CS_EFFECT.get()).m_20615_(owner.f_19853_);
        if (toFollow != null) {
            slash.m_6027_(toFollow.m_20185_() + offsetX, toFollow.m_20186_() - 1.5 + offsetY, toFollow.m_20189_() + offsetZ);
        } else {
            slash.m_6027_(owner.m_20185_() + offsetX, owner.m_20186_() - 1.5 + offsetY, owner.m_20189_() + offsetZ);
        }
        slash.setOwnerUuid(owner.m_20148_());
        slash.setToFollow(toFollow);
        slash.setEffectType(effectTypes);
        slash.setRandomRotation();
        float offsetRot = -10 + owner.m_217043_().m_188503_(10);
        slash.m_146922_(owner.m_146908_() + offsetRot);
        slash.f_19859_ = slash.m_146908_();
        slash.m_19915_(slash.m_146908_() + offsetRot, slash.m_146909_());
        return slash;
    }

    public void setRandomRotation() {
        int rotationX = this.f_19796_.m_188503_(360);
        int rotationZ = this.f_19796_.m_188503_(360);
        this.f_19804_.m_135381_(SET_ROT_X, (Object)rotationX);
        this.f_19804_.m_135381_(SET_ROT_Z, (Object)rotationZ);
    }

    public static void createInstance(Player owner, @Nullable Entity toFollow, CSEffectTypes effectTypes) {
        CSEffect.createInstance(owner, toFollow, effectTypes, 0.0, 0.0, 0.0);
    }

    public static void createInstance(Player owner, @Nullable Entity toFollow, CSEffectTypes effectTypes, double xOffset, double yOffset, double zOffset) {
        if (owner == null) {
            return;
        }
        CSEffect slash = CSEffect.getEffectInstance(owner, toFollow, effectTypes, xOffset, yOffset, zOffset);
        slash.setOwnerUuid(owner.m_20148_());
        owner.f_19853_.m_7967_((Entity)slash);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.getEffectType() != null) {
            state.getController().setAnimation(this.RAW_ANIM.thenPlay(this.getEffectType().getAnimation().getAnimationString()));
        } else {
            Celestisynth.LOGGER.warn("EffectType for CSEffect is null!");
            state.getController().setAnimation(this.RAW_ANIM.thenPlay("animation.cs_effect.spin"));
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        if (this.getOwnerUuid() == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        ++this.lifespan;
        if (this.lifespan >= this.getEffectType().getAnimation().getLifespan()) {
            this.setLifespan(0);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        ++this.frameTimer;
        if (this.frameTimer >= this.getEffectType().getFramesSpeed() - 1) {
            this.setFrameLevel(this.getFrameLevel() == this.getEffectType().getFrames() ? 1 : this.getFrameLevel() + 1);
            this.frameTimer = 0;
        }
        super.m_8119_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(TYPE_ID, (Object)"none");
        this.f_19804_.m_135372_(FRAME_LEVEL, (Object)1);
        this.f_19804_.m_135372_(SET_ROT_X, (Object)0);
        this.f_19804_.m_135372_(SET_ROT_Z, (Object)0);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7378_(CompoundTag compoundNBT) {
        UUID uuid;
        if (compoundNBT.m_128403_("Owner")) {
            uuid = compoundNBT.m_128342_("Owner");
        } else {
            String s = compoundNBT.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUuid(uuid);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("...Crescentia-Ranged got no goddamn owner.");
            }
        }
        this.setLifespan(compoundNBT.m_128451_("lifespan"));
        this.setTypeID(compoundNBT.m_128461_("typeId"));
    }

    public void m_7380_(CompoundTag compoundNBT) {
        if (this.getOwnerUuid() != null) {
            compoundNBT.m_128362_("Owner", this.getOwnerUuid());
        }
        compoundNBT.m_128405_("lifespan", this.lifespan);
        compoundNBT.m_128359_("typeId", this.getTypeID());
    }

    public CSEffectTypes getDefaultEffect() {
        return CSEffectTypes.SOLARIS_BLITZ;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

