/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.entities.renderer;

import com.aqutheseal.celestisynth.config.CSConfig;
import com.aqutheseal.celestisynth.entities.CSEffect;
import com.aqutheseal.celestisynth.entities.helper.CSEffectTypes;
import com.aqutheseal.celestisynth.entities.model.CSEffectModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CSEffectRenderer
extends GeoEntityRenderer<CSEffect> {
    public CSEffectRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CSEffectModel());
    }

    public void preRender(PoseStack poseStack, CSEffect animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)animatable.f_19859_, (float)animatable.m_146908_()) - 165.0f;
        float ageInTicks = (float)animatable.f_19797_ + partialTick;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (animatable.getEffectType().isRotateRandomly() && !animatable.getEffectType().hasSpecialProperties()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)animatable.getRotationX()));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)animatable.getRotationZ()));
        }
        CSEffectTypes.setSpecialProperties(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, CSEffect animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        float f = (float)animatable.getEffectType().getScale();
        super.scaleModelForRender(widthScale * f, heightScale * f, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public RenderType getRenderType(CSEffect animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_234338_((ResourceLocation)texture);
    }

    protected int getBlockLightLevel(CSEffect p_114496_, BlockPos p_114497_) {
        return 15;
    }

    protected int getSkyLightLevel(CSEffect p_114509_, BlockPos p_114510_) {
        return 15;
    }

    public Color getRenderColor(CSEffect animatable, float partialTick, int packedLight) {
        Minecraft mc = Minecraft.m_91087_();
        float decreasingAlpha = 1.0f;
        boolean shouldHideAtFirstPerson = false;
        if (animatable.getEffectType().isFadeOut()) {
            int lifespan = animatable.getEffectType().getAnimation().getLifespan();
            decreasingAlpha = 1.0f - (float)animatable.f_19797_ / (float)lifespan;
        }
        if (!((Boolean)CSConfig.CLIENT.visibilityOnFirstPerson.get()).booleanValue() && mc.f_91073_ != null && animatable.getOwnerUuid() != null && mc.f_91074_ != null && mc.f_91066_.m_92176_().m_90612_() && animatable.getOwnerUuid() == mc.f_91074_.m_20148_()) {
            shouldHideAtFirstPerson = true;
        }
        return Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)(shouldHideAtFirstPerson ? 0.0f : decreasingAlpha));
    }
}

