/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.item;

import com.aqutheseal.celestisynth.animation.AnimationManager;
import com.aqutheseal.celestisynth.config.CSConfig;
import com.aqutheseal.celestisynth.entities.CSEffect;
import com.aqutheseal.celestisynth.entities.CrescentiaRanged;
import com.aqutheseal.celestisynth.entities.helper.CSEffectTypes;
import com.aqutheseal.celestisynth.item.helpers.CSWeapon;
import com.aqutheseal.celestisynth.registry.CSEntityRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;

public class CrescentiaItem
extends SwordItem
implements CSWeapon {
    public static final String IS_RANGED_KEY = "cs.isRangedAttack";

    public CrescentiaItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    @Override
    public int getSkillsAmount() {
        return 2;
    }

    @Override
    public boolean hasPassive() {
        return true;
    }

    @Override
    public int getPassiveAmount() {
        return 1;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        CompoundTag itemTag = itemstack.m_41698_("csController");
        if (!player.m_36335_().m_41519_(itemstack.m_41720_()) && !itemTag.m_128471_("cs.hasAnimationBegun")) {
            itemTag.m_128379_("cs.hasAnimationBegun", true);
            itemTag.m_128379_(IS_RANGED_KEY, player.m_6144_());
            if (level.m_5776_()) {
                if (itemTag.m_128471_(IS_RANGED_KEY)) {
                    AnimationManager.playAnimation(AnimationManager.AnimationsList.ANIM_CRESCENTIA_THROW);
                } else {
                    AnimationManager.playAnimation(AnimationManager.AnimationsList.ANIM_CRESCENTIA_STRIKE);
                }
            }
            this.useAndDamageItem(itemstack, level, player, 4);
            player.m_36335_().m_41524_(itemstack.m_41720_(), itemTag.m_128471_(IS_RANGED_KEY) ? 40 : 100);
        }
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity source) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2));
        return super.m_7579_(itemStack, entity, source);
    }

    public void m_6883_(ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        CompoundTag data = itemStack.m_41698_("csController");
        if (entity instanceof Player) {
            player = (Player)entity;
            if (isSelected || player.m_21206_().m_41720_() instanceof CrescentiaItem) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 2, 0));
            }
        }
        if (data.m_128471_("cs.hasAnimationBegun") && entity instanceof Player) {
            player = (Player)entity;
            int animationTimer = data.m_128451_("cs.animationTimer");
            data.m_128405_("cs.animationTimer", animationTimer + 1);
            if (!data.m_128471_(IS_RANGED_KEY)) {
                this.tickMelee(itemStack, level, player, animationTimer);
            } else {
                this.tickRanged(itemStack, level, player, animationTimer);
            }
        }
    }

    public void tickRanged(ItemStack itemStack, Level level, Player player, int animationTimer) {
        CompoundTag data = itemStack.m_41698_("csController");
        if (animationTimer <= 20) {
            this.setDeltaPlayer(player, 0.0, 0.0, 0.0);
        }
        if (animationTimer == 20) {
            if (!level.m_5776_()) {
                CrescentiaRanged projectile = (CrescentiaRanged)((EntityType)CSEntityRegistry.CRESCENTIA_RANGED.get()).m_20615_(level);
                projectile.setOwnerUuid(player.m_20148_());
                projectile.setAngleX((float)this.calculateXLook(player));
                projectile.setAngleY((float)this.calculateYLook(player));
                projectile.setAngleZ((float)this.calculateZLook(player));
                projectile.setAddAngleX((float)this.calculateXLook(player) / 2.0f);
                projectile.setAddAngleY((float)this.calculateYLook(player) / 2.0f);
                projectile.setAddAngleZ((float)this.calculateZLook(player) / 2.0f);
                projectile.m_6027_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                level.m_7967_((Entity)projectile);
            }
            for (int i = 0; i < 10; ++i) {
                Random random = new Random();
                float offX = random.nextFloat() * 12.0f - 6.0f;
                float offY = random.nextFloat() * 12.0f - 6.0f;
                float offZ = random.nextFloat() * 12.0f - 6.0f;
                CrescentiaItem.createCrescentiaFirework(itemStack, level, player, player.m_20185_() + (double)offX, player.m_20186_() + (double)offY, player.m_20189_() + (double)offZ, true, animationTimer);
                player.m_5496_(SoundEvents.f_11913_, 1.0f, 1.5f);
            }
        }
        if (animationTimer >= 30) {
            data.m_128405_("cs.animationTimer", 0);
            data.m_128379_("cs.hasAnimationBegun", false);
        }
    }

    public void tickMelee(ItemStack itemStack, Level level, Player player, int animationTimer) {
        CompoundTag data = itemStack.m_41698_("csController");
        data.m_128405_("cs.animationTimer", animationTimer + 1);
        if (animationTimer >= 15 && animationTimer <= 60) {
            double range = 7.0;
            double rangeSq = Mth.m_144952_((double)range);
            List entities = level.m_45976_(Entity.class, player.m_20191_().m_82377_(range, range, range).m_82386_(this.calculateXLook(player), 0.0, this.calculateZLook(player)));
            for (Entity entityBatch : entities) {
                LivingEntity target;
                if (entityBatch instanceof LivingEntity && (target = (LivingEntity)entityBatch) != player && target.m_6084_() && !player.m_7307_((Entity)target) && target.m_20280_((Entity)player) < rangeSq) {
                    this.constantAttack(player, target, ((Float)CSConfig.COMMON.crescentiaSkillDmg.get()).floatValue() + (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)itemStack) / 2.2f);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
                }
                if (!(entityBatch instanceof Projectile)) continue;
                Projectile projectile = (Projectile)entityBatch;
                CrescentiaItem.createCrescentiaFirework(itemStack, level, player, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), true, animationTimer);
                player.m_5496_(SoundEvents.f_11932_, 1.0f, 1.0f);
                projectile.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (new Random().nextBoolean()) {
                CSEffect.createInstance(player, null, CSEffectTypes.CRESCENTIA_STRIKE, this.calculateXLook(player), 0.0, this.calculateZLook(player));
            } else {
                CSEffect.createInstance(player, null, CSEffectTypes.CRESCENTIA_STRIKE_INVERTED, this.calculateXLook(player), 0.0, this.calculateZLook(player));
            }
            CSEffect.createInstance(player, null, CSEffectTypes.SOLARIS_AIR);
            this.playRandomBladeSound((Entity)player, BASE_WEAPON_EFFECTS.length);
            Random random = new Random();
            float offX = random.nextFloat() * 12.0f - 6.0f;
            float offY = random.nextFloat() * 12.0f - 6.0f;
            float offZ = random.nextFloat() * 12.0f - 6.0f;
            CrescentiaItem.createCrescentiaFirework(itemStack, level, player, player.m_20185_() + (double)offX, player.m_20186_() + (double)offY, player.m_20189_() + (double)offZ, false, animationTimer);
        }
        if (animationTimer >= 70) {
            data.m_128405_("cs.animationTimer", 0);
            data.m_128379_("cs.hasAnimationBegun", false);
        }
    }

    public static void createCrescentiaFirework(ItemStack itemStack, Level level, Player player, double x, double y, double z, boolean isBig, int animationTimer) {
        Random random = new Random();
        if (animationTimer % 2 == 0) {
            ItemStack star = new ItemStack((ItemLike)Items.f_42689_);
            CompoundTag compoundtag = star.m_41698_("Explosion");
            ArrayList list = Lists.newArrayList();
            DyeColor[] allowedColors = new DyeColor[]{DyeColor.LIGHT_BLUE, DyeColor.WHITE, DyeColor.BLUE, DyeColor.MAGENTA};
            list.add(allowedColors[random.nextInt(allowedColors.length)].m_41070_());
            compoundtag.m_128408_("Colors", (List)list);
            compoundtag.m_128344_("Type", (byte)(isBig ? FireworkRocketItem.Shape.LARGE_BALL.m_41236_() : FireworkRocketItem.Shape.SMALL_BALL.m_41236_()));
            CompoundTag itemCompound = itemStack.m_41698_("Fireworks");
            ListTag listtag = new ListTag();
            CompoundTag starCompound = star.m_41737_("Explosion");
            if (starCompound != null) {
                listtag.add((Object)starCompound);
            }
            itemCompound.m_128344_("Flight", (byte)3);
            if (!listtag.isEmpty()) {
                itemCompound.m_128365_("Explosions", (Tag)listtag);
            }
            level.m_7228_(x, y, z, 0.1, 0.1, 0.1, itemCompound);
            player.m_5496_(SoundEvents.f_11930_, 1.0f, 0.5f + random.nextFloat());
        }
    }

    @Override
    public void onPlayerHurt(LivingHurtEvent event, ItemStack mainHandItem, ItemStack offHandItem) {
        LivingEntity entity = event.getEntity();
        CompoundTag tagR = mainHandItem.m_41720_().getShareTag(entity.m_21205_());
        CompoundTag tagL = offHandItem.m_41720_().getShareTag(entity.m_21206_());
        if (tagR != null && tagR.m_128471_("cs.hasAnimationBegun") || tagL != null && tagL.m_128471_("cs.hasAnimationBegun")) {
            event.setAmount(event.getAmount() * 0.7f);
        }
    }
}

