/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.item;

import com.aqutheseal.celestisynth.animation.AnimationManager;
import com.aqutheseal.celestisynth.config.CSConfig;
import com.aqutheseal.celestisynth.entities.CSEffect;
import com.aqutheseal.celestisynth.entities.helper.CSEffectTypes;
import com.aqutheseal.celestisynth.item.helpers.CSUtilityFunctions;
import com.aqutheseal.celestisynth.item.helpers.CSWeapon;
import com.aqutheseal.celestisynth.registry.CSSoundRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SolarisItem
extends SwordItem
implements CSWeapon {
    public static final String DIRECTION_INDEX_KEY = "cs.directionIndex";
    public static final String HEAD_ROT_LOCK_KEY = "cs.headRotLock";

    public SolarisItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    @Override
    public int getSkillsAmount() {
        return 2;
    }

    @Override
    public boolean hasPassive() {
        return true;
    }

    @Override
    public int getPassiveAmount() {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        CompoundTag itemTag = itemstack.m_41698_("csController");
        if (!player.m_36335_().m_41519_(itemstack.m_41720_()) && !itemTag.m_128471_("cs.hasAnimationBegun")) {
            if (level.m_5776_()) {
                AnimationManager.playAnimation(AnimationManager.AnimationsList.ANIM_SOLARIS_SPIN);
            }
            itemTag.m_128379_("cs.hasAnimationBegun", true);
            if (player.m_6144_()) {
                itemTag.m_128405_(DIRECTION_INDEX_KEY, 2);
                itemTag.m_128350_(HEAD_ROT_LOCK_KEY, player.m_146908_());
                this.useAndDamageItem(itemstack, level, player, 2);
                player.m_36335_().m_41524_(itemstack.m_41720_(), 130);
            } else {
                itemTag.m_128405_(DIRECTION_INDEX_KEY, player.m_217043_().m_188503_(2));
                this.useAndDamageItem(itemstack, level, player, 3);
                player.m_36335_().m_41524_(itemstack.m_41720_(), 70);
            }
        }
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity source) {
        entity.m_20254_(5);
        return super.m_7579_(itemStack, entity, source);
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        CompoundTag data = itemStack.m_41698_("csController");
        if (entity instanceof Player) {
            player = (Player)entity;
            if (isSelected || player.m_21206_().m_41720_() instanceof SolarisItem) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 2, 0));
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (data.m_128471_("cs.hasAnimationBegun")) {
                int i;
                int animationTimer = data.m_128451_("cs.animationTimer");
                data.m_128405_("cs.animationTimer", animationTimer + 1);
                if (animationTimer == 13) {
                    player.m_216990_((SoundEvent)CSSoundRegistry.CS_STEP.get());
                    for (i = 0; i < 15; ++i) {
                        Random rand = new Random();
                        if (!(level instanceof ServerLevel)) continue;
                        CSUtilityFunctions.sendParticles((ServerLevel)level, ParticleTypes.f_123755_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0, (double)(-1.0f + rand.nextFloat(2.0f)) * 0.5, 0.1, (double)(-1.0f + rand.nextFloat(2.0f)) * 0.5);
                    }
                }
                if (animationTimer > 0 && animationTimer < 24) {
                    if (level instanceof ServerLevel) {
                        if (data.m_128451_(DIRECTION_INDEX_KEY) == 2) {
                            for (i = 0; i < 10; ++i) {
                                CSUtilityFunctions.sendParticles((ServerLevel)level, ParticleTypes.f_123745_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0, (double)(-1.0f + new Random().nextFloat(2.0f)), 0.1, (double)(-1.0f + new Random().nextFloat(2.0f)));
                            }
                        } else {
                            CSUtilityFunctions.sendParticles((ServerLevel)level, ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0, 0.0, 0.1, 0.0);
                        }
                    }
                    player.m_20334_(0.0, 0.0, 0.0);
                    player.f_19864_ = true;
                } else if (animationTimer > 23 && animationTimer < 60) {
                    BlockPos blockPosForAttack = player.m_20183_();
                    boolean isStraight = data.m_128451_(DIRECTION_INDEX_KEY) == 2;
                    int range = isStraight ? 7 : 4;
                    List entities = level.m_45976_(LivingEntity.class, new AABB(blockPosForAttack.m_7918_(-range, -range, -range), blockPosForAttack.m_7918_(range, range, range)));
                    for (LivingEntity target : entities) {
                        if (target == player || player.m_7307_((Entity)target) || !target.m_6084_()) continue;
                        this.constantAttack(player, target, (isStraight ? (Float)CSConfig.COMMON.solarisShiftSkillDmg.get() : (Float)CSConfig.COMMON.solarisSkillDmg.get()).floatValue() + (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)itemStack) / 2.5f);
                        target.m_20254_(5);
                    }
                    player.m_216990_(SoundEvents.f_12455_);
                    if (data.m_128451_(DIRECTION_INDEX_KEY) == 2) {
                        this.movePlayerInStraightMotion(player, data.m_128451_(HEAD_ROT_LOCK_KEY));
                        CSEffect.createInstance(player, null, CSEffectTypes.SOLARIS_BLITZ_SOUL);
                        CSEffect.createInstance(player, null, CSEffectTypes.SOLARIS_AIR_LARGE);
                        this.playRandomBladeSound((Entity)player, BASE_WEAPON_EFFECTS.length);
                    } else if (data.m_128451_(DIRECTION_INDEX_KEY) == 0) {
                        this.movePlayerInCircularMotion(player, animationTimer, false);
                        CSEffect.createInstance(player, null, CSEffectTypes.SOLARIS_BLITZ);
                        CSEffect.createInstance(player, null, CSEffectTypes.SOLARIS_AIR);
                        this.playRandomBladeSound((Entity)player, 4);
                    } else if (data.m_128451_(DIRECTION_INDEX_KEY) == 1) {
                        this.movePlayerInCircularMotion(player, animationTimer, true);
                        CSEffect.createInstance(player, null, CSEffectTypes.SOLARIS_BLITZ);
                        CSEffect.createInstance(player, null, CSEffectTypes.SOLARIS_AIR);
                        this.playRandomBladeSound((Entity)player, 4);
                    }
                    BlockPos playerPos = player.m_20183_();
                    double radius = 3.0;
                    double particleCount = 50.0;
                    double angleIncrement = Math.PI * 2 / particleCount;
                    int i2 = 0;
                    while ((double)i2 < particleCount) {
                        double angle = (double)i2 * angleIncrement;
                        double rotationX = level.f_46441_.m_188500_() * 360.0;
                        double rotationZ = level.f_46441_.m_188500_() * 360.0;
                        double x = (double)playerPos.m_123341_() + radius * Math.cos(angle);
                        double y = (double)playerPos.m_123342_() + 1.5;
                        double z = (double)playerPos.m_123343_() + radius * Math.sin(angle);
                        double motionX = Math.sin(Math.toRadians(rotationX)) * Math.cos(Math.toRadians(rotationZ));
                        double motionY = Math.sin(Math.toRadians(rotationZ));
                        double motionZ = Math.cos(Math.toRadians(rotationX)) * Math.cos(Math.toRadians(rotationZ));
                        if (level instanceof ServerLevel) {
                            CSUtilityFunctions.sendParticles((ServerLevel)level, data.m_128451_(DIRECTION_INDEX_KEY) == 2 ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_, x + 0.5, y, z + 0.5, 0, motionX, motionY, motionZ);
                            if (data.m_128451_(DIRECTION_INDEX_KEY) == 2) {
                                CSUtilityFunctions.sendParticles((ServerLevel)level, ParticleTypes.f_123746_, x + 0.5, y, z + 0.5, 0, motionX, motionY, motionZ);
                            }
                        }
                        ++i2;
                    }
                }
                if (animationTimer >= 80) {
                    data.m_128405_(DIRECTION_INDEX_KEY, player.m_217043_().m_188503_(2));
                    data.m_128350_(HEAD_ROT_LOCK_KEY, 0.0f);
                    data.m_128405_("cs.animationTimer", 0);
                    data.m_128379_("cs.hasAnimationBegun", false);
                }
            }
        }
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
    }

    private void movePlayerInCircularMotion(Player player, int tick, boolean isRight) {
        double radius = 1.5;
        double forwardX = Math.sin(Math.toRadians(player.m_146908_()));
        double forwardZ = -Math.cos(Math.toRadians(player.m_146908_()));
        double perpendicularX = -forwardZ;
        double perpendicularZ = forwardX;
        double angle = (double)(tick - 45) / 25.0 * Math.PI * 2.0;
        double offsetX = radius * Math.cos(angle);
        double offsetZ = radius * Math.sin(angle);
        double finalX = isRight ? player.m_20185_() + forwardX * offsetX - perpendicularX * offsetZ : player.m_20185_() + forwardX * offsetX + perpendicularX * offsetZ;
        double finalZ = isRight ? player.m_20189_() + forwardZ * offsetX - perpendicularZ * offsetZ : player.m_20189_() + forwardZ * offsetX + perpendicularZ * offsetZ;
        player.m_20334_(finalX - player.m_20185_(), player.m_20184_().f_82480_, finalZ - player.m_20189_());
    }

    private void movePlayerInStraightMotion(Player player, float yRot) {
        double speed = 1.5;
        double lookX = -Math.sin(Math.toRadians(yRot));
        double lookZ = Math.cos(Math.toRadians(yRot));
        double motionX = lookX * speed;
        double motionZ = lookZ * speed;
        player.m_20334_(motionX, player.m_20184_().f_82480_, motionZ);
    }
}

