/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.item.helpers;

import com.aqutheseal.celestisynth.item.helpers.CSUtilityFunctions;
import com.aqutheseal.celestisynth.registry.CSSoundRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public interface CSWeapon {
    public static final String CS_CONTROLLER_TAG_ELEMENT = "csController";
    public static final String CS_EXTRAS_ELEMENT = "csExtras";
    public static final String ANIMATION_TIMER_KEY = "cs.animationTimer";
    public static final String ANIMATION_BEGUN_KEY = "cs.hasAnimationBegun";
    public static final SoundEvent[] BASE_WEAPON_EFFECTS = new SoundEvent[]{(SoundEvent)CSSoundRegistry.CS_SWORD_SWING.get(), (SoundEvent)CSSoundRegistry.CS_SWORD_SWING_FIRE.get(), (SoundEvent)CSSoundRegistry.CS_AIR_SWING.get(), (SoundEvent)CSSoundRegistry.CS_SWORD_CLASH.get(), (SoundEvent)CSSoundRegistry.CS_FIRE_SHOOT.get(), (SoundEvent)CSSoundRegistry.CS_IMPACT_HIT.get()};

    public int getSkillsAmount();

    default public int getPassiveAmount() {
        return 1;
    }

    default public boolean hasPassive() {
        return false;
    }

    default public void onPlayerHurt(LivingHurtEvent event, ItemStack mainHandItem, ItemStack offHandItem) {
    }

    default public void playRandomBladeSound(Entity entity, int length) {
        SoundEvent randomSound = BASE_WEAPON_EFFECTS[new Random().nextInt(length)];
        entity.m_5496_(randomSound, 0.55f, 0.5f + new Random().nextFloat());
    }

    default public void constantAttack(Player holder, LivingEntity target, float damage) {
        double preAttribute = target.m_21051_(Attributes.f_22278_).m_22135_();
        target.m_21051_(Attributes.f_22278_).m_22100_(100.0);
        target.f_19802_ = 0;
        target.m_6469_(holder.m_269291_().m_269075_(holder), damage);
        target.m_21051_(Attributes.f_22278_).m_22100_(preAttribute);
    }

    default public void setDeltaPlayer(Player player, double x, double y, double z) {
        player.f_19864_ = true;
        player.m_20334_(x, y, z);
        player.f_19812_ = true;
    }

    default public void setDeltaPlayer(Player player, Vec3 vec) {
        player.f_19864_ = true;
        player.m_20256_(vec);
    }

    default public void useAndDamageItem(ItemStack pStack, Level pLevel, Player player, int damageAmount) {
        if (!pLevel.f_46443_) {
            pStack.m_41622_(damageAmount, (LivingEntity)player, p_43388_ -> p_43388_.m_21190_(player.m_7655_()));
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)pStack.m_41720_()));
    }

    default public void sendExpandingParticles(Level level, ParticleType<?> particleType, double x, double y, double z, int amount, float expansionMultiplier) {
        for (int i = 0; i < amount; ++i) {
            Random random = new Random();
            float offX = (-0.5f + random.nextFloat()) * expansionMultiplier;
            float offY = (-0.5f + random.nextFloat()) * expansionMultiplier;
            float offZ = (-0.5f + random.nextFloat()) * expansionMultiplier;
            CSUtilityFunctions.sendParticles(level, particleType, x, y, z, 0, (double)offX, (double)offY, (double)offZ);
        }
    }

    default public void sendExpandingParticles(Level level, ParticleType<?> particleType, BlockPos origin, int amount, float expansionMultiplier) {
        this.sendExpandingParticles(level, particleType, origin.m_123341_(), origin.m_123342_(), origin.m_123343_(), amount, expansionMultiplier);
    }

    default public Entity getLookAtEntity(Player player, double range) {
        AABB aabb;
        double distance = range * range;
        Vec3 vec = player.m_20299_(1.0f);
        Vec3 vec1 = player.m_20252_(1.0f);
        Vec3 targetVec = vec.m_82520_(vec1.f_82479_ * range, vec1.f_82480_ * range, vec1.f_82481_ * range);
        EntityHitResult result = ProjectileUtil.m_37287_((Entity)player, (Vec3)vec, (Vec3)targetVec, (AABB)(aabb = player.m_20191_().m_82369_(vec1.m_82490_(range)).m_82377_(4.0, 4.0, 4.0)), entity -> !entity.m_5833_(), (double)distance);
        return result != null ? result.m_82443_() : null;
    }

    default public double calculateXLook(Player player) {
        return -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
    }

    default public double calculateYLook(Player player) {
        return -Mth.m_14031_((float)(player.m_146909_() * ((float)Math.PI / 180)));
    }

    default public double calculateZLook(Player player) {
        return Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
    }
}

