/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.IPacketReceiver;
import net.smart.moving.IPacketSender;
import net.smart.moving.SMContext;
import net.smart.moving.SMFactory;
import net.smart.moving.SMOther;
import net.smart.moving.SMPacketHandler;
import net.smart.moving.config.SMOptions;
import net.smart.moving.config.SMServerConfig;
import net.smart.properties.Property;

public class SMComm
implements IPacketReceiver,
IPacketSender {
    public static final SMServerConfig ServerConfig = new SMServerConfig();
    public static final SMComm instance = new SMComm();

    @Override
    public boolean processStatePacket(IMessage message, IEntityPlayerMP player, int entityId, long state) {
        SMOther moving;
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId);
        if (entity != null && entity instanceof EntityOtherPlayerMP && (moving = SMFactory.getOtherSmartMoving((EntityOtherPlayerMP)entity)) != null) {
            moving.processStatePacket(state);
        }
        return true;
    }

    @Override
    public boolean processConfigInfoPacket(IMessage message, IEntityPlayerMP player, String info) {
        return false;
    }

    @Override
    public boolean processConfigContentPacket(IMessage message, IEntityPlayerMP player, String[] content, String username) {
        SMComm.processConfigPacket(content, username, false);
        return true;
    }

    @Override
    public boolean processConfigChangePacket(IMessage message, IEntityPlayerMP player) {
        SMOptions.writeNoRightsToChangeConfigMessageToChat(SMComm.isConnectedToRemoteServer());
        return true;
    }

    @Override
    public boolean processSpeedChangePacket(IMessage message, IEntityPlayerMP player, int difference, String username) {
        if (difference == 0) {
            SMOptions.writeNoRightsToChangeSpeedMessageToChat(SMComm.isConnectedToRemoteServer());
        } else {
            SMContext.Config.changeSpeed(difference);
            SMContext.Options.writeServerSpeedMessageToChat(username, (Boolean)SMContext.Config._globalConfig.value);
        }
        return true;
    }

    @Override
    public boolean processHungerChangePacket(IMessage message, IEntityPlayerMP player, float hunger) {
        player.localAddExhaustion(hunger);
        return true;
    }

    @Override
    public boolean processSoundPacket(IMessage message, IEntityPlayerMP player, String soundId, float distance, float pitch) {
        return false;
    }

    private static boolean isConnectedToRemoteServer() {
        IntegratedServer integratedServer = Minecraft.func_71410_x().func_71401_C();
        return FMLCommonHandler.instance().getMinecraftServerInstance() == null || integratedServer == null || !integratedServer.func_71264_H();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void processConfigPacket(String[] content, String username, boolean blockCode) {
        boolean first;
        boolean isGloballyConfigured = false;
        if (content != null && content.length == 2 && SMContext.Options._globalConfig.getCurrentKey().equals(content[0])) {
            isGloballyConfigured = "true".equals(content[1]);
            content = null;
        }
        boolean wasEnabled = SMContext.Config.enabled;
        boolean bl = first = SMContext.Config != ServerConfig;
        if (first) {
            ServerConfig.reset();
        }
        if (content != null) {
            if (content.length == 0) {
                SMContext.Config = SMContext.Options;
                SMContext.Options.writeServerDeconfigMessageToChat();
                return;
            }
            ServerConfig.loadFromProperties(content, blockCode);
            isGloballyConfigured = (Boolean)SMComm.ServerConfig._globalConfig.value;
        } else {
            ServerConfig.load(false);
            ServerConfig.setCurrentKey(null);
        }
        SMComm.ServerConfig._globalConfig.value = isGloballyConfigured;
        if (!first) {
            SMContext.Options.writeServerReconfigMessageToChat(wasEnabled, username, isGloballyConfigured);
            return;
        }
        SMContext.Config = ServerConfig;
        SMContext.Options.writeServerConfigMessageToChat();
        if (!blockCode) {
            SMPacketHandler.sendConfigInfo(instance, "3.2");
        }
    }

    @Override
    public void sendPacket(IMessage message) {
        SMPacketHandler.INSTANCE.sendToServer(message);
    }

    public static boolean processBlockCode(String text) {
        if (!text.startsWith("\u00a70\u00a71") || !text.endsWith("\u00a7f\u00a7f")) {
            return false;
        }
        String codes = text.substring(4, text.length() - 4);
        SMComm.processBlockCode(codes, "\u00a70", SMContext.Options._baseClimb, "standard");
        SMComm.processBlockCode(codes, "\u00a71", SMContext.Options._freeClimb, new String[0]);
        SMComm.processBlockCode(codes, "\u00a72", SMContext.Options._ceilingClimbing, new String[0]);
        SMComm.processBlockCode(codes, "\u00a73", SMContext.Options._swim, new String[0]);
        SMComm.processBlockCode(codes, "\u00a74", SMContext.Options._dive, new String[0]);
        SMComm.processBlockCode(codes, "\u00a75", SMContext.Options._crawl, new String[0]);
        SMComm.processBlockCode(codes, "\u00a76", SMContext.Options._slide, new String[0]);
        SMComm.processBlockCode(codes, "\u00a77", SMContext.Options._fly, new String[0]);
        SMComm.processBlockCode(codes, "\u00a78", SMContext.Options._jumpCharge, new String[0]);
        SMComm.processBlockCode(codes, "\u00a79", SMContext.Options._headJump, new String[0]);
        SMComm.processBlockCode(codes, "\u00a7a", SMContext.Options._angleJumpSide, new String[0]);
        SMComm.processBlockCode(codes, "\u00a7b", SMContext.Options._angleJumpBack, new String[0]);
        return true;
    }

    private static void processBlockCode(String text, String blockCode, Property<?> property, String ... value) {
        if (text.contains(blockCode)) {
            SMComm.processConfigPacket(new String[]{property.getCurrentKey(), value.length > 0 ? value[0] : "false"}, null, true);
        }
    }
}

