/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.util.Hashtable;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.smart.moving.IEntityPlayerSP;
import net.smart.moving.SMBase;
import net.smart.moving.SMOther;
import net.smart.moving.SMPlayerBase;

public class SMFactory {
    private static SMFactory factory;
    private Hashtable<Integer, SMOther> otherSmartMovings;

    public SMFactory() {
        if (factory != null) {
            throw new RuntimeException("FATAL: Can only create one instance of type 'SmartMovingFactory'");
        }
        factory = this;
    }

    protected static boolean isInitialized() {
        return factory != null;
    }

    public static void initialize() {
        if (!SMFactory.isInitialized()) {
            new SMFactory();
        }
    }

    public static void handleMultiPlayerTick(Minecraft minecraft) {
        factory.doHandleMultiPlayerTick(minecraft);
    }

    public static SMBase getInstance(EntityPlayer entityPlayer) {
        return factory.doGetInstance(entityPlayer);
    }

    public static SMBase getOtherSmartMoving(int entityId) {
        return factory.doGetOtherSmartMoving(entityId);
    }

    public static SMOther getOtherSmartMoving(EntityOtherPlayerMP entity) {
        return factory.doGetOtherSmartMoving(entity);
    }

    protected void doHandleMultiPlayerTick(Minecraft minecraft) {
        SMOther moving;
        for (Entity player : minecraft.field_71441_e.field_73010_i) {
            if (!(player instanceof EntityOtherPlayerMP)) continue;
            EntityOtherPlayerMP otherPlayer = (EntityOtherPlayerMP)player;
            moving = this.doGetOtherSmartMoving(otherPlayer);
            moving.spawnParticles(minecraft, otherPlayer.field_70165_t - otherPlayer.field_70169_q, otherPlayer.field_70161_v - otherPlayer.field_70166_s);
            moving.foundAlive = true;
        }
        if (this.otherSmartMovings == null || this.otherSmartMovings.isEmpty()) {
            return;
        }
        Iterator<Integer> entityIds = this.otherSmartMovings.keySet().iterator();
        while (entityIds.hasNext()) {
            Integer entityId = entityIds.next();
            moving = this.otherSmartMovings.get(entityId);
            if (moving.foundAlive) {
                moving.foundAlive = false;
                continue;
            }
            entityIds.remove();
        }
    }

    protected SMBase doGetInstance(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityOtherPlayerMP) {
            return this.doGetOtherSmartMoving(entityPlayer.func_145782_y());
        }
        if (entityPlayer instanceof IEntityPlayerSP) {
            return ((IEntityPlayerSP)entityPlayer).getMoving();
        }
        if (entityPlayer instanceof EntityPlayerSP) {
            return SMPlayerBase.getPlayerBase((EntityPlayerSP)entityPlayer).getMoving();
        }
        return null;
    }

    protected SMBase doGetOtherSmartMoving(int entityId) {
        Entity entity;
        SMOther moving = this.tryGetOtherSmartMoving(entityId);
        if (moving == null && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId)) != null && entity instanceof EntityOtherPlayerMP) {
            moving = this.addOtherSmartMoving((EntityOtherPlayerMP)entity);
        }
        return moving;
    }

    protected SMOther doGetOtherSmartMoving(EntityOtherPlayerMP entity) {
        SMOther moving = this.tryGetOtherSmartMoving(entity.func_145782_y());
        if (moving == null) {
            moving = this.addOtherSmartMoving(entity);
        }
        return moving;
    }

    protected final SMOther tryGetOtherSmartMoving(int entityId) {
        if (this.otherSmartMovings == null) {
            this.otherSmartMovings = new Hashtable();
        }
        return this.otherSmartMovings.get(entityId);
    }

    protected final SMOther addOtherSmartMoving(EntityOtherPlayerMP entity) {
        SMOther moving = new SMOther(entity);
        this.otherSmartMovings.put(entity.func_145782_y(), moving);
        return moving;
    }
}

