/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.smart.moving.SMComm;
import net.smart.moving.SMPacketHandler;
import net.smart.moving.SMServerComm;
import net.smart.moving.SMServerPlayerBase;

public class SoundPacket
implements IMessage {
    public static final byte PacketId = 6;
    public String soundId;
    public float volume;
    public float pitch;

    public SoundPacket() {
    }

    public SoundPacket(String soundId, float volume, float pitch) {
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void fromBytes(ByteBuf buf) {
        int soundIdLength = buf.readInt();
        this.soundId = buf.readCharSequence(soundIdLength, StandardCharsets.UTF_8).toString();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.soundId.length());
        buf.writeCharSequence((CharSequence)this.soundId, StandardCharsets.UTF_8);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    public static class ServerHandler
    implements IMessageHandler<SoundPacket, IMessage> {
        public IMessage onMessage(SoundPacket message, MessageContext ctx) {
            SMServerPlayerBase serverPlayer = SMServerPlayerBase.getPlayerBase(ctx.getServerHandler().field_147369_b);
            SMPacketHandler.receivePacket(message, SMServerComm.instance, serverPlayer);
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<SoundPacket, IMessage> {
        public IMessage onMessage(SoundPacket message, MessageContext ctx) {
            SMPacketHandler.receivePacket(message, SMComm.instance, null);
            return null;
        }
    }
}

