/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.smart.moving.SMComm;
import net.smart.moving.SMPacketHandler;
import net.smart.moving.SMServerComm;
import net.smart.moving.SMServerPlayerBase;

public class SpeedChangePacket
implements IMessage {
    public static final byte PacketId = 4;
    public int difference;
    public String username;

    public SpeedChangePacket() {
    }

    public SpeedChangePacket(int difference, String username) {
        this.difference = difference;
        this.username = username;
    }

    public void fromBytes(ByteBuf buf) {
        this.difference = buf.readInt();
        int usernameLength = buf.readInt();
        this.username = buf.readCharSequence(usernameLength, StandardCharsets.UTF_8).toString();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.difference);
        buf.writeInt(this.username.length());
        buf.writeCharSequence((CharSequence)this.username, StandardCharsets.UTF_8);
    }

    public static class ServerHandler
    implements IMessageHandler<SpeedChangePacket, IMessage> {
        public IMessage onMessage(SpeedChangePacket message, MessageContext ctx) {
            SMServerPlayerBase serverPlayer = SMServerPlayerBase.getPlayerBase(ctx.getServerHandler().field_147369_b);
            SMPacketHandler.receivePacket(message, SMServerComm.instance, serverPlayer);
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<SpeedChangePacket, IMessage> {
        public IMessage onMessage(SpeedChangePacket message, MessageContext ctx) {
            SMPacketHandler.receivePacket(message, SMComm.instance, null);
            return null;
        }
    }
}

