/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.eventhandler;

import com.mojang.serialization.Codec;
import com.tristankechlo.explorations.Explorations;
import com.tristankechlo.explorations.init.ModStructures;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WorldLoadingHandler {
    private static Method GETCODEC_METHOD;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)event.getWorld();
        if (this.isTerraForged(serverWorld)) {
            return;
        }
        if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
            return;
        }
        HashMap<IForgeRegistryEntry, StructureSeparationSettings> tempMap = new HashMap<IForgeRegistryEntry, StructureSeparationSettings>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
        tempMap.putIfAbsent(ModStructures.FORGOTTEN_WELL.get(), this.getSettings((Structure)ModStructures.FORGOTTEN_WELL.get()));
        tempMap.putIfAbsent(ModStructures.JUNGLE_TEMPLE.get(), this.getSettings((Structure)ModStructures.JUNGLE_TEMPLE.get()));
        tempMap.putIfAbsent(ModStructures.UNDERGROUND_TEMPLE.get(), this.getSettings((Structure)ModStructures.UNDERGROUND_TEMPLE.get()));
        serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
    }

    private boolean isTerraForged(ServerWorld serverWorld) {
        try {
            ResourceLocation cgRL;
            if (GETCODEC_METHOD == null) {
                GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
            }
            if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                return true;
            }
        }
        catch (Exception e) {
            Explorations.LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
        }
        return false;
    }

    private StructureSeparationSettings getSettings(Structure<?> structure) {
        return (StructureSeparationSettings)DimensionStructuresSettings.field_236191_b_.get(structure);
    }
}

