/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.structures;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class JungleTempleStructure
extends Structure<NoFeatureConfig> {
    public static final List<String> DEFAULT_BIOMES = JungleTempleStructure.getDefaultSpawnBiomes();

    public JungleTempleStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        BlockPos centerOfChunk = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
        return topBlock.func_204520_s().func_206888_e() && landHeight <= 80;
    }

    private static List<String> getDefaultSpawnBiomes() {
        ArrayList<String> biomes = new ArrayList<String>();
        biomes.add(Biomes.field_76782_w.func_240901_a_().toString());
        biomes.add(Biomes.field_150574_L.func_240901_a_().toString());
        biomes.add(Biomes.field_76792_x.func_240901_a_().toString());
        biomes.add(Biomes.field_185446_X.func_240901_a_().toString());
        biomes.add(Biomes.field_185447_Y.func_240901_a_().toString());
        biomes.add(Biomes.field_222370_aw.func_240901_a_().toString());
        biomes.add(Biomes.field_222371_ax.func_240901_a_().toString());
        return biomes;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        private static final ResourceLocation START_POOL = new ResourceLocation("explorations", "jungle_temple/jungle_temple_start");

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos centerPos = new BlockPos(x - this.field_214631_d.nextInt(10), 0, z - this.field_214631_d.nextInt(10));
            int maxDepth = 5;
            boolean placeAtHeightMap = true;
            boolean intersecting = false;
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> this.getJigsawPattern(dynamicRegistryManager), 5), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)centerPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            int xOffset = centerPos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = centerPos.func_177952_p() - structureCenter.func_177952_p();
            this.field_75075_a.forEach(piece -> piece.func_181138_a(xOffset, 0, zOffset));
            this.func_202500_a();
        }

        public void func_230366_a_(ISeedReader seedReader, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos pos) {
            super.func_230366_a_(seedReader, manager, chunkGenerator, random, boundingBox, pos);
            int i = this.field_75074_b.field_78895_b;
            for (int j = boundingBox.field_78897_a; j <= boundingBox.field_78893_d; ++j) {
                for (int k = boundingBox.field_78896_c; k <= boundingBox.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (seedReader.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vector3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vector3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (seedReader.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || seedReader.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        if (random.nextFloat() < 0.3f) {
                            seedReader.func_180501_a(blockpos1, Blocks.field_196698_dj.func_176223_P(), 2);
                            continue;
                        }
                        seedReader.func_180501_a(blockpos1, Blocks.field_196696_di.func_176223_P(), 2);
                    }
                }
            }
        }

        private JigsawPattern getJigsawPattern(DynamicRegistries dynamicRegistryManager) {
            return (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(START_POOL);
        }
    }
}

