/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.eventhandler;

import com.mojang.serialization.Codec;
import com.tristankechlo.explorations.Explorations;
import com.tristankechlo.explorations.init.ModStructures;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class WorldLoadingHandler {
    private static Method GETCODEC_METHOD;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (!(event.getWorld() instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)event.getWorld();
        if (this.isTerraForged(serverWorld)) {
            return;
        }
        if (serverWorld.m_7726_().m_8481_() instanceof FlatLevelSource && serverWorld.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(serverWorld.m_7726_().f_8328_.m_62205_().m_64590_());
        tempMap.putIfAbsent((StructureFeature)ModStructures.FORGOTTEN_WELL.get(), this.getSettings((StructureFeature)ModStructures.FORGOTTEN_WELL.get()));
        tempMap.putIfAbsent((StructureFeature)ModStructures.JUNGLE_TEMPLE.get(), this.getSettings((StructureFeature)ModStructures.JUNGLE_TEMPLE.get()));
        tempMap.putIfAbsent((StructureFeature)ModStructures.UNDERGROUND_TEMPLE.get(), this.getSettings((StructureFeature)ModStructures.UNDERGROUND_TEMPLE.get()));
        serverWorld.m_7726_().f_8328_.m_62205_().f_64582_ = tempMap;
    }

    private boolean isTerraForged(ServerLevel serverWorld) {
        try {
            ResourceLocation cgRL;
            if (GETCODEC_METHOD == null) {
                GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
            }
            if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.m_7726_().f_8328_, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                return true;
            }
        }
        catch (Exception e) {
            Explorations.LOGGER.error("Was unable to check if " + serverWorld.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
        }
        return false;
    }

    private StructureFeatureConfiguration getSettings(StructureFeature<?> structure) {
        return (StructureFeatureConfiguration)StructureSettings.f_64580_.get(structure);
    }
}

