/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.tristankechlo.explorations.structures.ForgottenWellStructure;
import com.tristankechlo.explorations.structures.JungleTempleStructure;
import com.tristankechlo.explorations.structures.UnderGroundTempleStructure;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModStructures {
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"explorations");
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> FORGOTTEN_WELL = STRUCTURES.register("forgotten_well", () -> new ForgottenWellStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> JUNGLE_TEMPLE = STRUCTURES.register("jungle_temple", () -> new JungleTempleStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> UNDERGROUND_TEMPLE = STRUCTURES.register("underground_temple", () -> new UnderGroundTempleStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand((StructureFeature)FORGOTTEN_WELL.get(), new StructureFeatureConfiguration(10, 5, 2147413647), false);
        ModStructures.setupMapSpacingAndLand((StructureFeature)JUNGLE_TEMPLE.get(), new StructureFeatureConfiguration(17, 6, 2147413646), false);
        ModStructures.setupMapSpacingAndLand((StructureFeature)UNDERGROUND_TEMPLE.get(), new StructureFeatureConfiguration(15, 6, 2147413645), false);
    }

    private static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureSeparationSettings, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureSeparationSettings).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

