/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.structures;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.NoiseAffectingStructureStart;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class ForgottenWellStructure
extends StructureFeature<NoneFeatureConfiguration> {
    public static final List<String> DEFAULT_BIOMES = ForgottenWellStructure.getDefaultSpawnBiomes();

    public ForgottenWellStructure(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return Start::new;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, WorldgenRandom random, ChunkPos chunkPos1, Biome biome, ChunkPos chunkPos2, NoneFeatureConfiguration featureConfig, LevelHeightAccessor heightLimitView) {
        BlockPos blockPos = chunkPos1.m_45615_();
        int landHeight = chunkGenerator.m_156179_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(blockPos.m_123341_(), blockPos.m_123343_(), heightLimitView);
        BlockState topBlock = columnOfBlocks.m_47156_(blockPos.m_6630_(landHeight));
        return topBlock.m_60819_().m_76178_();
    }

    private static List<String> getDefaultSpawnBiomes() {
        ArrayList<String> biomes = new ArrayList<String>();
        biomes.add(Biomes.f_48205_.m_135782_().toString());
        biomes.add(Biomes.f_48149_.m_135782_().toString());
        biomes.add(Biomes.f_48150_.m_135782_().toString());
        biomes.add(Biomes.f_48151_.m_135782_().toString());
        biomes.add(Biomes.f_48187_.m_135782_().toString());
        biomes.add(Biomes.f_48185_.m_135782_().toString());
        biomes.add(Biomes.f_48179_.m_135782_().toString());
        return biomes;
    }

    public static class Start
    extends NoiseAffectingStructureStart<NoneFeatureConfiguration> {
        public static final ResourceLocation START_POOL = new ResourceLocation("explorations", "forgotten_well_start_pool");

        public Start(StructureFeature<NoneFeatureConfiguration> structureIn, ChunkPos chunkPos, int referenceIn, long seedIn) {
            super(structureIn, chunkPos, referenceIn, seedIn);
        }

        public void generatePieces(RegistryAccess dynamicRegistryAccess, ChunkGenerator chunkGenerator, StructureManager structureManager, ChunkPos chunkPos, Biome biomeIn, NoneFeatureConfiguration config, LevelHeightAccessor heightLimitView) {
            BlockPos structureBlockPos = new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
            int maxDepth = 10;
            boolean intersecting = false;
            boolean placeAtHeightMap = true;
            JigsawPlacement.m_161612_((RegistryAccess)dynamicRegistryAccess, (JigsawConfiguration)new JigsawConfiguration(() -> this.getJigsawPattern(dynamicRegistryAccess), 10), PoolElementStructurePiece::new, (ChunkGenerator)chunkGenerator, (StructureManager)structureManager, (BlockPos)structureBlockPos, (StructurePieceAccessor)this, (Random)this.f_73564_, (boolean)false, (boolean)true, (LevelHeightAccessor)heightLimitView);
            this.f_73562_.forEach(piece -> piece.m_6324_(0, -2, 0));
            BlockPos structureCenter = ((StructurePiece)this.f_73562_.get(0)).m_73547_().m_162394_();
            int xOffset = structureBlockPos.m_123341_() - structureCenter.m_123341_();
            int zOffset = structureBlockPos.m_123343_() - structureCenter.m_123343_();
            this.f_73562_.forEach(piece -> piece.m_6324_(xOffset, 0, zOffset));
            this.m_73601_();
        }

        private StructureTemplatePool getJigsawPattern(RegistryAccess dynamicRegistryManager) {
            return (StructureTemplatePool)dynamicRegistryManager.m_175515_(Registry.f_122884_).m_7745_(START_POOL);
        }
    }
}

