/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.structures;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.NoiseAffectingStructureStart;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class JungleTempleStructure
extends StructureFeature<NoneFeatureConfiguration> {
    public static final List<String> DEFAULT_BIOMES = JungleTempleStructure.getDefaultSpawnBiomes();

    public JungleTempleStructure(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return Start::new;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, WorldgenRandom random, ChunkPos chunkPos1, Biome biome, ChunkPos chunkPos2, NoneFeatureConfiguration featureConfig, LevelHeightAccessor heightLimitView) {
        BlockPos centerOfChunk = chunkPos1.m_45615_();
        int landHeight = chunkGenerator.m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), heightLimitView);
        BlockState topBlock = columnOfBlocks.m_47156_(centerOfChunk.m_6630_(landHeight));
        return topBlock.m_60819_().m_76178_() && landHeight <= 80;
    }

    private static List<String> getDefaultSpawnBiomes() {
        ArrayList<String> biomes = new ArrayList<String>();
        biomes.add(Biomes.f_48222_.m_135782_().toString());
        biomes.add(Biomes.f_48224_.m_135782_().toString());
        biomes.add(Biomes.f_48223_.m_135782_().toString());
        biomes.add(Biomes.f_48183_.m_135782_().toString());
        biomes.add(Biomes.f_48184_.m_135782_().toString());
        biomes.add(Biomes.f_48197_.m_135782_().toString());
        biomes.add(Biomes.f_48198_.m_135782_().toString());
        return biomes;
    }

    public static class Start
    extends NoiseAffectingStructureStart<NoneFeatureConfiguration> {
        private static final ResourceLocation START_POOL = new ResourceLocation("explorations", "jungle_temple/jungle_temple_start");

        public Start(StructureFeature<NoneFeatureConfiguration> structureIn, ChunkPos chunkPos, int referenceIn, long seedIn) {
            super(structureIn, chunkPos, referenceIn, seedIn);
        }

        public void generatePieces(RegistryAccess dynamicRegistryAccess, ChunkGenerator chunkGenerator, StructureManager structureManager, ChunkPos chunkPos, Biome biomeIn, NoneFeatureConfiguration config, LevelHeightAccessor heightLimitView) {
            BlockPos structureBlockPos = new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
            int maxDepth = 5;
            boolean placeAtHeightMap = true;
            boolean intersecting = false;
            JigsawPlacement.m_161612_((RegistryAccess)dynamicRegistryAccess, (JigsawConfiguration)new JigsawConfiguration(() -> this.getJigsawPattern(dynamicRegistryAccess), 5), PoolElementStructurePiece::new, (ChunkGenerator)chunkGenerator, (StructureManager)structureManager, (BlockPos)structureBlockPos, (StructurePieceAccessor)this, (Random)this.f_73564_, (boolean)false, (boolean)true, (LevelHeightAccessor)heightLimitView);
            this.f_73562_.forEach(piece -> piece.m_6324_(0, 1, 0));
            BlockPos structureCenter = ((StructurePiece)this.f_73562_.get(0)).m_73547_().m_162394_();
            int xOffset = structureBlockPos.m_123341_() - structureCenter.m_123341_();
            int zOffset = structureBlockPos.m_123343_() - structureCenter.m_123343_();
            this.f_73562_.forEach(piece -> piece.m_6324_(xOffset, 0, zOffset));
            this.m_73601_();
        }

        public void m_7129_(WorldGenLevel level, StructureFeatureManager manager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos) {
            super.m_7129_(level, manager, chunkGenerator, random, boundingBox, chunkPos);
            int i = this.m_73601_().m_162396_();
            for (int j = boundingBox.m_162395_(); j <= boundingBox.m_162399_(); ++j) {
                for (int k = boundingBox.m_162398_(); k <= boundingBox.m_162401_(); ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (level.m_46859_(blockpos) || !this.m_73601_().m_71051_((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.f_73562_) {
                        if (!structurepiece.m_73547_().m_71051_((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && !level.m_46859_(blockpos1 = new BlockPos(j, l, k)) && !level.m_8055_(blockpos1).m_60767_().m_76332_(); --l) {
                        if (random.nextFloat() < 0.3f) {
                            level.m_7731_(blockpos1, Blocks.f_50223_.m_49966_(), 2);
                            continue;
                        }
                        level.m_7731_(blockpos1, Blocks.f_50222_.m_49966_(), 2);
                    }
                }
            }
        }

        private StructureTemplatePool getJigsawPattern(RegistryAccess dynamicRegistryManager) {
            return (StructureTemplatePool)dynamicRegistryManager.m_175515_(Registry.f_122884_).m_7745_(START_POOL);
        }
    }
}

