/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.NoiseAffectingStructureStart;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class UnderGroundTempleStructure
extends StructureFeature<NoneFeatureConfiguration> {
    private static final List<MobSpawnSettings.SpawnerData> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20459_, 100, 4, 9), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20493_, 100, 4, 9), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20513_, 100, 4, 9));

    public UnderGroundTempleStructure(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return Start::new;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, WorldgenRandom random, ChunkPos chunkPos1, Biome biome, ChunkPos chunkPos2, NoneFeatureConfiguration featureConfig, LevelHeightAccessor heightLimitView) {
        return random.nextDouble() < 0.6;
    }

    public static class Start
    extends NoiseAffectingStructureStart<NoneFeatureConfiguration> {
        private static final ResourceLocation START_POOL = new ResourceLocation("explorations", "underground_temple/underground_temple_start");

        public Start(StructureFeature<NoneFeatureConfiguration> structureIn, ChunkPos chunkPos, int referenceIn, long seedIn) {
            super(structureIn, chunkPos, referenceIn, seedIn);
        }

        public void generatePieces(RegistryAccess dynamicRegistryAccess, ChunkGenerator chunkGenerator, StructureManager structureManager, ChunkPos chunkPos, Biome biomeIn, NoneFeatureConfiguration config, LevelHeightAccessor heightLimitView) {
            BlockPos structureBlockPos = new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
            int maxDepth = 6;
            boolean placeAtHeightMap = false;
            boolean intersecting = false;
            JigsawPlacement.m_161612_((RegistryAccess)dynamicRegistryAccess, (JigsawConfiguration)new JigsawConfiguration(() -> this.getJigsawPattern(dynamicRegistryAccess), 6), PoolElementStructurePiece::new, (ChunkGenerator)chunkGenerator, (StructureManager)structureManager, (BlockPos)structureBlockPos, (StructurePieceAccessor)this, (Random)this.f_73564_, (boolean)false, (boolean)false, (LevelHeightAccessor)heightLimitView);
            BlockPos structureCenter = ((StructurePiece)this.f_73562_.get(0)).m_73547_().m_162394_();
            int xOffset = structureBlockPos.m_123341_() - structureCenter.m_123341_();
            int zOffset = structureBlockPos.m_123343_() - structureCenter.m_123343_();
            this.f_73562_.forEach(piece -> piece.m_6324_(xOffset, 0, zOffset));
            this.m_73601_();
            this.m_163601_(chunkGenerator.m_6337_(), chunkGenerator.m_142062_(), (Random)this.f_73564_, 20);
        }

        private StructureTemplatePool getJigsawPattern(RegistryAccess dynamicRegistryManager) {
            return (StructureTemplatePool)dynamicRegistryManager.m_175515_(Registry.f_122884_).m_7745_(START_POOL);
        }
    }
}

