/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.treedecorators;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worlgen.treedecorators.TreeDecoratorContext;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4662;
import net.minecraft.class_4663;

public class CaveVineDecorator
extends class_4662 {
    public static final Codec<CaveVineDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("start_chance").forGetter(decorator -> Float.valueOf(decorator.startProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("berry_chance").forGetter(decorator -> Float.valueOf(decorator.berrySpawnChance)), (App)Codec.intRange((int)0, (int)10).optionalFieldOf("max_vine_length", (Object)4).forGetter(decorator -> decorator.maxVineLength), (App)Codec.BOOL.optionalFieldOf("only_outer_leaves", (Object)true).forGetter(decorator -> decorator.onlyOuterLeaves)).apply((Applicative)builder, CaveVineDecorator::new));
    private final float startProbability;
    private final float berrySpawnChance;
    private final int maxVineLength;
    private final boolean onlyOuterLeaves;

    public CaveVineDecorator(float startProbability, float berrySpawnChance, int maxVineLength, boolean onlyOuterLeaves) {
        this.startProbability = startProbability;
        this.berrySpawnChance = berrySpawnChance;
        this.maxVineLength = maxVineLength;
        this.onlyOuterLeaves = onlyOuterLeaves;
    }

    protected class_4663<?> method_28893() {
        return ModRegistry.CAVE_VINES.get();
    }

    public void method_23469(class_3746 level, BiConsumer<class_2338, class_2680> states, Random random, List<class_2338> var4, List<class_2338> leaves) {
        TreeDecoratorContext context = new TreeDecoratorContext(level, states, random, leaves);
        this.place(context);
    }

    private void place(TreeDecoratorContext context) {
        Random random = context.random();
        context.leaves().forEach(blockPosLeave -> {
            if (random.nextFloat() < this.startProbability) {
                if (this.onlyOuterLeaves && !CaveVineDecorator.isOuterBlock(blockPosLeave, context)) {
                    return;
                }
                class_2338 pos = blockPosLeave.method_10074();
                if (context.isAir(pos)) {
                    CaveVineDecorator.addCaveVines(pos, context, this.berrySpawnChance, this.maxVineLength);
                }
            }
        });
    }

    private static boolean isOuterBlock(class_2338 startPos, TreeDecoratorContext context) {
        ImmutableList neighbours = ImmutableList.of((Object)startPos.method_10095(), (Object)startPos.method_10078(), (Object)startPos.method_10072(), (Object)startPos.method_10067());
        for (class_2338 pos : neighbours) {
            if (!context.isAir(pos)) continue;
            return true;
        }
        return false;
    }

    private static void addCaveVines(class_2338 startPos, TreeDecoratorContext context, float berryChance, int maxVineLength) {
        Random random = context.random();
        class_2338 blockpos = startPos;
        for (int i = maxVineLength; context.isAir(blockpos) && i > 0; --i) {
            class_2680 state = class_2246.field_28675.method_9564();
            if (random.nextFloat() < berryChance) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_28716, (Comparable)Boolean.TRUE);
            }
            context.setBlock(blockpos, state);
            blockpos = blockpos.method_10074();
        }
    }
}

