/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worlgen.treedecorators.TreeDecoratorContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_3749;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_5172;
import net.minecraft.class_6016;
import net.minecraft.class_6017;

public class LanternDecorator
extends class_4662 {
    public static final Codec<LanternDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)class_6017.method_35004((int)0, (int)10).fieldOf("lantern_count").orElse((Object)class_6016.method_34998((int)3)).forGetter(decorator -> decorator.count), (App)class_6017.method_35004((int)0, (int)10).fieldOf("chain_length").orElse((Object)class_6016.method_34998((int)1)).forGetter(decorator -> decorator.chainLength)).apply((Applicative)builder, LanternDecorator::new));
    private final class_2680 chain = (class_2680)class_2246.field_23985.method_9564().method_11657((class_2769)class_5172.field_11459, (Comparable)class_2350.class_2351.field_11052);
    private final class_2680 lantern = (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.TRUE);
    private final float probability;
    private final class_6017 count;
    private final class_6017 chainLength;

    public LanternDecorator(float probability, class_6017 count, class_6017 chainLength) {
        this.probability = probability;
        this.count = count;
        this.chainLength = chainLength;
    }

    protected class_4663<?> method_28893() {
        return ModRegistry.LANTERN.get();
    }

    public void method_23469(class_3746 level, BiConsumer<class_2338, class_2680> states, Random random, List<class_2338> var4, List<class_2338> leaves) {
        TreeDecoratorContext context = new TreeDecoratorContext(level, states, random, leaves);
        this.place(context);
    }

    private void place(TreeDecoratorContext context) {
        Random random = context.random();
        if (random.nextFloat() > this.probability) {
            return;
        }
        int count = this.count.method_35008(random);
        List<class_2338> possible = LanternDecorator.getLeavesShuffled(context, count);
        for (int i = 0; i < possible.size(); ++i) {
            class_2338 blockpos = possible.get(i);
            for (int length = this.chainLength.method_35008(random); context.isAir(blockpos) && length > 0; --length) {
                context.setBlock(blockpos, this.chain);
                blockpos = blockpos.method_10074();
            }
            context.setBlock(blockpos, this.lantern);
        }
    }

    private static List<class_2338> getLeavesShuffled(TreeDecoratorContext context, int maxCount) {
        Random random = context.random();
        List all = context.leaves().stream().map(pos -> pos.method_10074()).filter(pos -> context.isAir((class_2338)pos)).collect(Collectors.toList());
        HashSet<class_2338> target = new HashSet<class_2338>();
        for (int maxIndex = Math.min(maxCount, all.size()); maxIndex > 0 && all.size() > 0; --maxIndex) {
            class_2338 pos2 = (class_2338)all.remove(random.nextInt(all.size()));
            target.add(pos2);
        }
        return new ArrayList<class_2338>(target);
    }
}

