/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public abstract class JigsawStructure
extends class_3195 {
    protected final JigsawStructureSettings settings;

    public JigsawStructure(class_3195.class_7302 config, JigsawStructureSettings settings) {
        super(config);
        this.settings = settings;
    }

    public static <S extends JigsawStructure> Codec<S> createCodec(BiFunction<class_3195.class_7302, JigsawStructureSettings, S> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3195.method_42697((RecordCodecBuilder.Instance)instance), JigsawStructure.jigsawSettingsCodec(instance)).apply((Applicative)instance, factory)).codec();
    }

    public static <S extends JigsawStructure> RecordCodecBuilder<S, JigsawStructureSettings> jigsawSettingsCodec(RecordCodecBuilder.Instance<S> instance) {
        return JigsawStructureSettings.CODEC.forGetter(s -> s.settings);
    }

    @NotNull
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!this.isFeatureChunk(context)) {
            return Optional.empty();
        }
        class_2338 blockpos = this.generateStartPos(context);
        if (blockpos == null) {
            return Optional.empty();
        }
        return class_3778.method_30419((class_3195.class_7149)context, this.settings.startPool(), this.settings.startJigsawName(), (int)this.settings.size(), (class_2338)blockpos, (boolean)false, Optional.empty(), (int)this.settings.maxDistanceFromCenter());
    }

    protected abstract class_2338 generateStartPos(class_3195.class_7149 var1);

    protected abstract boolean isFeatureChunk(class_3195.class_7149 var1);

    public record JigsawStructureSettings(class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, int maxDistanceFromCenter) {
        public static final MapCodec<JigsawStructureSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3785.field_24954.fieldOf("start_pool").forGetter(JigsawStructureSettings::startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(JigsawStructureSettings::startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").orElse((Object)5).forGetter(JigsawStructureSettings::size), (App)Codec.intRange((int)0, (int)30).fieldOf("max_distance_from_center").orElse((Object)50).forGetter(JigsawStructureSettings::maxDistanceFromCenter)).apply((Applicative)instance, JigsawStructureSettings::new));
    }
}

