/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worlgen.structures.pieces.SlimeCaveStructurePiece;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2893;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_6626;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public final class SlimeCaveStructure
extends class_3195 {
    public static final Codec<SlimeCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41236).fieldOf("biomes").forGetter(s -> s.biomes)).apply((Applicative)instance, SlimeCaveStructure::new)).codec();
    private static final class_2960 ID = new class_2960("explorations", "slime_cave");
    private final class_6885<class_1959> biomes;

    public SlimeCaveStructure(class_6885<class_1959> biomes) {
        super(SlimeCaveStructure.makeSettings(biomes));
        this.biomes = biomes;
    }

    public static class_3195.class_7302 makeSettings(class_6885<class_1959> biomes) {
        return new class_3195.class_7302(biomes, Map.of(), class_2893.class_2895.field_13172, class_5847.field_28923);
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2919 random = context.comp_566();
        int maxY = context.comp_562().method_16398();
        if (maxY <= 30) {
            return Optional.empty();
        }
        int minY = context.comp_562().method_33730() + 15;
        int y = minY + random.method_43048((maxY -= 20) - minY);
        class_2338 pos = context.comp_568().method_8323().method_33096(y);
        return Optional.of(new class_3195.class_7150(pos, builder -> this.generatePieces((class_6626)builder, context, pos)));
    }

    private void generatePieces(class_6626 builder, class_3195.class_7149 context, class_2338 pos) {
        class_3485 templateManager = context.comp_565();
        class_2470 rotation = class_2470.method_16548((class_5819)context.comp_566());
        builder.method_35462((class_3443)new SlimeCaveStructurePiece(templateManager, ID, pos, rotation));
    }

    public class_7151<?> method_41618() {
        return ModRegistry.SLIME_CAVE_STRUCTURE.get();
    }
}

