/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.structures.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class StoneBrickAgingProcessor
extends class_3491 {
    public static final Codec<StoneBrickAgingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Chances.CODEC.fieldOf("chances").forGetter(processor -> processor.chances)).apply((Applicative)instance, StoneBrickAgingProcessor::new));
    private static final List<class_2248> STONE_BRICKS_REPLACEMENTS = List.of(class_2246.field_10065, class_2246.field_10416);
    private static final Map<class_2248, class_2248> BRICKS = Map.of(class_2246.field_10552, class_2246.field_10416, class_2246.field_28900, class_2246.field_29222, class_2246.field_28896, class_2246.field_29223);
    private final Chances chances;

    public StoneBrickAgingProcessor(Chances chances) {
        this.chances = chances;
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 level, class_2338 var2, class_2338 var3, class_3499.class_3501 var4, class_3499.class_3501 var5, class_3492 var6) {
        class_2680 old = var5.field_15596;
        class_2680 replacement = null;
        class_5819 random = var6.method_15115(var5.field_15597);
        if (old.method_27852(class_2246.field_10056)) {
            class_2248 block = (class_2248)class_156.method_32309(STONE_BRICKS_REPLACEMENTS, (class_5819)random);
            replacement = this.tryReplacing(block, old, random, this.chances.bricks());
        } else if (old.method_27852(class_2246.field_10392)) {
            replacement = this.tryReplacing(class_2246.field_10173, old, random, this.chances.stairs());
        } else if (old.method_27852(class_2246.field_10131)) {
            replacement = this.tryReplacing(class_2246.field_10024, old, random, this.chances.slabs());
        } else if (old.method_27852(class_2246.field_10252)) {
            replacement = this.tryReplacing(class_2246.field_10059, old, random, this.chances.walls());
        } else if (BRICKS.containsKey(old.method_26204())) {
            class_2248 temp = BRICKS.get(old.method_26204());
            replacement = this.tryReplacing(temp, old, random, this.chances.bricks());
        }
        if (replacement == null) {
            return var5;
        }
        return new class_3499.class_3501(var5.field_15597, replacement, var5.field_15595);
    }

    private class_2680 tryReplacing(class_2248 block, class_2680 defaultState, class_5819 random, float chance) {
        if (random.method_43057() < chance) {
            class_2680 state = block.method_9564();
            for (class_2769 property : defaultState.method_28501()) {
                if (!state.method_28498(property)) continue;
                state = StoneBrickAgingProcessor.copyProperty(defaultState, state, property);
            }
            return state;
        }
        return defaultState;
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 from, class_2680 to, class_2769<T> property) {
        return (class_2680)to.method_11657(property, from.method_11654(property));
    }

    protected class_3828<?> method_16772() {
        return ModRegistry.STONE_BRICK_AGING_PROCESSOR.get();
    }

    private record Chances(float bricks, float walls, float stairs, float slabs) {
        public static final Codec<Chances> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("bricks").orElse((Object)Float.valueOf(0.25f)).forGetter(Chances::bricks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("walls").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::walls), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stairs").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::stairs), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("slabs").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::slabs)).apply((Applicative)instance, Chances::new));
    }
}

