/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations;

import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.registration.RegistryObject;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="explorations")
@Mod.EventBusSubscriber(modid="explorations")
public final class ForgeExplorations {
    private static final List<ResourceKey<Biome>> LARGE_MUSHROOM_BIOMES = List.of(Biomes.f_48151_);
    private static final List<ResourceKey<Biome>> SCARECROW_ACACIA_BIOMES = List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_);
    private static final List<ResourceKey<Biome>> SCARECROW_BIRCH_BIOMES = List.of(Biomes.f_48149_, Biomes.f_186762_);
    private static final List<ResourceKey<Biome>> SCARECROW_DARK_OAK_BIOMES = List.of(Biomes.f_48151_);
    private static final List<ResourceKey<Biome>> SCARECROW_JUNGLE_BIOMES = List.of(Biomes.f_48222_, Biomes.f_48197_, Biomes.f_186769_);
    private static final List<ResourceKey<Biome>> SCARECROW_OAK_BIOMES = List.of(Biomes.f_48205_, Biomes.f_48151_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48179_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186755_);
    private static final List<ResourceKey<Biome>> SCARECROW_SPRUCE_BIOMES = List.of(Biomes.f_48152_, Biomes.f_48206_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_186755_, Biomes.f_186765_);

    public ForgeExplorations() {
        ModRegistry.loadClass();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ForgeExplorations.addFeature(event, ModRegistry.LARGE_MUSHROOM_PLACED, LARGE_MUSHROOM_BIOMES);
        ForgeExplorations.addFeature(event, ModRegistry.SCARECROW_ACACIA_PLACED, SCARECROW_ACACIA_BIOMES);
        ForgeExplorations.addFeature(event, ModRegistry.SCARECROW_BIRCH_PLACED, SCARECROW_BIRCH_BIOMES);
        ForgeExplorations.addFeature(event, ModRegistry.SCARECROW_DARK_OAK_PLACED, SCARECROW_DARK_OAK_BIOMES);
        ForgeExplorations.addFeature(event, ModRegistry.SCARECROW_JUNGLE_PLACED, SCARECROW_JUNGLE_BIOMES);
        ForgeExplorations.addFeature(event, ModRegistry.SCARECROW_OAK_PLACED, SCARECROW_OAK_BIOMES);
        ForgeExplorations.addFeature(event, ModRegistry.SCARECROW_SPRUCE_PLACED, SCARECROW_SPRUCE_BIOMES);
    }

    private static void addFeature(BiomeLoadingEvent event, RegistryObject<PlacedFeature> feature, List<ResourceKey<Biome>> biomes) {
        ResourceLocation name = event.getName();
        if (name == null) {
            return;
        }
        ResourceKey biome = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
        if (biomes.contains(biome)) {
            GenerationStep.Decoration step = GenerationStep.Decoration.VEGETAL_DECORATION;
            event.getGeneration().m_204201_(step, feature.asHolder());
        }
    }
}

