/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worlgen.features;

import com.mojang.serialization.Codec;
import com.tristankechlo.explorations.worlgen.features.config.ScarecrowFeatureConfig;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ScarecrowFeature
extends Feature<ScarecrowFeatureConfig> {
    public ScarecrowFeature(Codec<ScarecrowFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ScarecrowFeatureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        Random random = context.m_159776_();
        Direction facingHead = Direction.Plane.HORIZONTAL.m_122560_(random);
        Direction facingArmLeft = facingHead.m_175362_(Direction.Axis.Y);
        Direction facingArmRight = facingHead.m_175364_(Direction.Axis.Y);
        BlockPos posLeg = context.m_159777_();
        BlockPos posBody = posLeg.m_6630_(1);
        BlockPos posHead = posLeg.m_6630_(2);
        BlockPos posLeftArm = posLeg.m_7494_().m_142300_(facingArmLeft);
        BlockPos posRightArm = posLeg.m_7494_().m_142300_(facingArmRight);
        if (!ScarecrowFeature.canBePlaced(level, ((ScarecrowFeatureConfig)context.m_159778_()).forcePlace(), posLeg, posBody, posHead, posLeftArm, posRightArm)) {
            return false;
        }
        BlockState stateHead = ScarecrowFeature.createHead(((ScarecrowFeatureConfig)context.m_159778_()).head().m_7112_(random, posHead), facingHead);
        BlockState stateBody = ((ScarecrowFeatureConfig)context.m_159778_()).body().m_7112_(random, posBody);
        BlockState stateLegs = ((ScarecrowFeatureConfig)context.m_159778_()).legs().m_7112_(random, posLeg);
        BlockState stateArmLeft = ScarecrowFeature.createArm(((ScarecrowFeatureConfig)context.m_159778_()).arms().m_7112_(random, posLeftArm), facingArmLeft);
        BlockState stateArmRight = ScarecrowFeature.createArm(((ScarecrowFeatureConfig)context.m_159778_()).arms().m_7112_(random, posRightArm), facingArmRight);
        level.m_7731_(posLeg, stateLegs, 3);
        level.m_7731_(posBody, stateBody, 3);
        level.m_7731_(posLeftArm, stateArmLeft, 3);
        level.m_7731_(posRightArm, stateArmRight, 3);
        level.m_7731_(posHead, stateHead, 3);
        return true;
    }

    private static BlockState createArm(BlockState armState, Direction facing) {
        if (facing == Direction.NORTH && armState.m_61138_((Property)BlockStateProperties.f_61370_)) {
            armState = (BlockState)armState.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.TRUE);
        } else if (facing == Direction.EAST && armState.m_61138_((Property)BlockStateProperties.f_61371_)) {
            armState = (BlockState)armState.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.TRUE);
        } else if (facing == Direction.SOUTH && armState.m_61138_((Property)BlockStateProperties.f_61368_)) {
            armState = (BlockState)armState.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.TRUE);
        } else if (facing == Direction.WEST && armState.m_61138_((Property)BlockStateProperties.f_61369_)) {
            armState = (BlockState)armState.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.TRUE);
        }
        return armState;
    }

    private static BlockState createHead(BlockState headState, Direction facing) {
        if (headState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            headState = (BlockState)headState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
        } else if (headState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            headState = (BlockState)headState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
        }
        return headState;
    }

    private static boolean canBePlaced(WorldGenLevel level, boolean forceReplace, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            boolean replaceable;
            if (level.m_151570_(pos) || level.m_8055_(pos).m_204336_(BlockTags.f_144287_)) {
                return false;
            }
            BlockState state = level.m_8055_(pos);
            boolean bl = replaceable = forceReplace || level.m_46859_(pos) || state.m_60767_().m_76332_() || state.m_60767_().m_76336_();
            if (replaceable) continue;
            return false;
        }
        return true;
    }
}

